/* -*- mode: c++; c-basic-offset: 4; -*- */
//#############################################################################
//#  DuoTone Timing Montoring Program    v0.0
//#  
//#  By:   Szabi Marka, Oct 2005
//#
//#############################################################################

#include "DuoTone.hh"

#ifndef __CINT__

//#include "ProcIdent.hh"
#include <iostream>
#include <fstream>
#include <sstream>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include "TSeries.hh"
#include "FSeries.hh"
#include "Dacc.hh"

#include "DVecType.hh"
#include <string.h>
#include <cstdlib>
#include "FixedLenTS.hh"
#include <signal.h>


//-------------------------------------- 

EXECDAT(DuoTone)
#endif               // !def(__CINT__)

char ChSlsc[255] = "H1:LSC-TIME_MON";         // Default name of input channels
char ChSpem[255] = "H1:GDS-TIME_MON";         // Default name of input channels
char ChRpem[255] = "H1:DAQ-GPS_RAMP_L1";      // Default name of input channels
char IFO[4]      = "H1";                      // Name of ifo 
char MatLog[255] = "/tmp/H1/mat.log";         // Name of file containing the matlab script output
char RES[255]    = "/tmp/H1/Results.txt";     // Name of file containing the results
char ChFile[255] = "X";                       // Name of input file   
char WebDir[255] = "/import/space/apacheFiles/htdocs/gds/monitor_reports/DuoTone/index.html";
char LogDir[255] = "/export/home/smarka/DuoTone/log/log.txt";
char TmpDir[255] = "/tmp/H1/DuoToneTmpData.dat";
char LXO[4]      = "L?O";
char COMM[255]   = "date; unsetenv DISPLAY; cd /tmp/H1; /export/home/smarka/DuoTone/DuoToneM; date";
char CLEAN[255]  = "rm /tmp/H1/*";
int  ct = 0, wc=0;
char DataServer[80]      = "H1:DuoTone_DataServer";
char TrendTitle[80]      = "H1-DuoTone-Minute-Trend";
char trend[80]           = "H1:DMT-TIME_";
char trendChan_zSlsc[80] = "xxx";
char trendChan_zSpem[80] = "xxx";
char trendChan_zRpem[80] = "xxx";
char trendChan_LSC[80]   = "xxx";
char trendChan_ERR[80]   = "xxx";
char trendChan_QAF[80]   = "xxx";
char TrendName[80]  = "H1:DuoTone";
bool Epics          = false;
char EpicsName[80]  = "H0:DMT-TM_4KLSC";
char CaPutDir[256]  = "/cvs/cds/epics/extensions/bin/solaris";
char CaPutCom[256]  = "caput";
char EpicsComm[256] = "";
char TTAG_Ch[40]    = "H0:DMT-DUOTONE_TTAG";
char ALIVE_Ch[40]   = "H0:DMT-DUOTONE_ALIVE";
char BinDir[255]    = "/export/home/smarka/DuoTone/DuoToneM" ;
char Alive(0);
int  ErrCode        = 0;
int  QualCode       = 0;
char AlarmMsg[255]  = "xxx";
int  Fs = 16384;

static const Interval HalfSec(0.51);

using namespace std;

DuoTone::DuoTone(int argc, const char *argv[])                     // DuoTone  constructor
  : DatEnv(argc, argv),
    MonServer("DuoTone_Junk"),
    MaxFrame(999999999), 
    mTrendMinute("DuoToneTrend", Trend::kMinute, 720),
    mAlarm("DUOTONE")
{
  strncpy(LXO, getenv("LIGOSITE"), 3); 
  if (!(strcmp(LXO,"LLO") || strcmp(LXO,"LHO"))) {
    cerr << LXO << " cannot be identified as LIGO site! Check the $LIGOSITE environmental variable" << endl;
    exit(0);
  }
#ifdef DEBUG_DUOTONE
  cout << "LIGO Site identified : " << LXO << endl;
#endif

  if (!strcmp(LXO,"LHO")) {
    strcpy(WebDir, "/cvs/cds/lho/web/gds/monitor_reports/DuoTone/index.html");
    strcpy(LogDir, "/export/home/smarka/DuoTone/log/log.txt");
  }

#ifdef DEBUG_DUOTONE
  cout << "Usage: DuoTone \n"  
       << "        [optional -h provides this help \n"
       << "        [optional -b <executable name> Matlab .m compiled binary directory and name \n"
       << "        [optional -e <Epics Ch name root> switch ON epics communication \n"
       << "        [optional -i <IFO, e.g. H1, H2, L1> specifies ifo \n"
       << "        [optional -cSl <LSC dualtone channel name>] \n" 
       << "        [optional -cSp <PEM dualtone channel name>] \n" 
       << "        [optional -cRp <PEM RAMP channel name>] \n" 
       << "        [optional -t <trend output channel name root>] \n"
       << "        [optional -f (read from file) <filename> Don't forget the quotes!] \n" 
       << "        [optional -n N maximum number of frames to read]\n" 
       << "        [optional -w Web output directory]\n "
       << "        [optional -l Log output directory/file]\n "
       << "Example: DuoTone -e H1:DMT-TM_ -cSl H1:LSC-TIME_MON -cSp H1:GDS-TIME_MON -cRp H1:DAQ-GPS_RAMP_L1 -t H1:DMT-DUOT_ -b /export/home/smarka/DuoTone/DuoToneM -i H1 \n"
       << endl;
#endif  
    for (int i=1 ; i<argc ; i++) {
        if (!strcmp("-h", argv[i])) {
           cout << "Usage: DuoTone \n" 
		<< "        [optional -h provides this help \n"
		<< "        [optional -b <executable name> Matlab .m compiled binary directory and name \n"
                << "        [optional -e <Epics Ch Name> switch ON epics communication \n"
                << "        [optional -i <IFO, e.g. H1, H2, L1> specifies ifo \n"
		<< "        [optional -cSl <LSC dualtone channel name>] \n" 
		<< "        [optional -cSp <PEM dualtone channel name>] \n" 
		<< "        [optional -cRp <PEM RAMP channel name>] \n" 
		<< "        [optional -t <trend output channel name>] \n"
		<< "        [optional -f (read from file) <filename>] \n" 
		<< "        [optional -n N maximum number of frames to read]\n" 
		<< "        [optional -w Web output directory/file] " 
		<< "        [optional -l Log output directory/file] "
		<< "Example: DuoTone -e H1:DMT-TM_ -cSl H1:LSC-TIME_MON -cSp H1:GDS-TIME_MON -cRp H1:DAQ-GPS_RAMP_L1 -t H1:DMT-DUOT_  -b /export/home/smarka/DuoTone/DuoToneM -i H1 \n"
		<< endl;
	   exit(0);
	}
        if (!strcmp("-e", argv[i])) {
	  strcpy(EpicsName, argv[++i]);
	  Epics = true;
#ifdef DEBUG_DUOTONE
	  cout << "Epics communication is ON! " << EpicsName << endl;
#endif
	}       
	if (!strcmp("-t", argv[i])) {
	  strcpy(trend, argv[++i]);
#ifdef DEBUG_DUOTONE
    cout << "Output trend channel loaded from command line : " << trend << endl;
#endif
	}
        if (!strcmp("-b", argv[i])) {
	    strcpy(BinDir, argv[++i]);
#ifdef DEBUG_DUOTONE
    cout << "Binary executable dir/name loaded from command line : " << BinDir 
	 << endl;
#endif
	}
        if (!strcmp("-i", argv[i])) {
	    strcpy(IFO, argv[++i]);
#ifdef DEBUG_DUOTONE
    cout << "IFO name loaded from command line : " << IFO << endl;
#endif
	}
        if (!strcmp("-cSl", argv[i])) {
	    strcpy(ChSlsc, argv[++i]);
#ifdef DEBUG_DUOTONE
    cout << "LSC dualtone channel loaded from command line : " << ChSlsc 
	 << endl;
#endif
	}
        if (!strcmp("-cSp", argv[i])) {
	    strcpy(ChSpem, argv[++i]);
#ifdef DEBUG_DUOTONE
    cout << "PEM dualtone channel loaded from command line : " << ChSpem 
	 << endl;
#endif
	}
        if (!strcmp("-cRp", argv[i])) {
	    strcpy(ChRpem, argv[++i]);
#ifdef DEBUG_DUOTONE
    cout << "PEM Ramp channel loaded from command line : " << ChRpem << endl;
#endif
	}
        if (!strcmp("-n", argv[i])) {
	    MaxFrame = strtol(argv[++i], 0, 0);
#ifdef DEBUG_DUOTONE
    cout << "Maximum number of frames loaded from command line : " <<  MaxFrame
	 << endl;
#endif
	} 
        if (!strcmp("-f", argv[i])) {
	    strcpy(ChFile, argv[++i]);
	    getDacc().close();
	    getDacc().addPath(ChFile);
#ifdef DEBUG_DUOTONE
    cout << "Frames are loaded from : " << ChFile  << endl;
#endif
	}
        if (!strcmp("-w", argv[i])) {
	    strcpy(WebDir, argv[++i]);
#ifdef DEBUG_DUOTONE
    cout << "Web output is going to : " << WebDir  << endl;
#endif
	} 
        if (!strcmp("-l", argv[i])) {
	    strcpy(LogDir, argv[++i]);

#ifdef DEBUG_DUOTONE
    cout << "Log output is going to : " << LogDir  << endl;
#endif
	} 
    }

    sprintf(COMM,   "mkdir -p /tmp/%s", IFO);
    int sysrc = system(COMM);
    sprintf(CLEAN,  "rm /tmp/%s/*", IFO);
    sysrc = system(CLEAN);
    sprintf(COMM,   "unset DISPLAY; cd /tmp/%s; %s > /tmp/%s/mat.log 2>&1 ", 
	    IFO, BinDir, IFO);
    if (sysrc) {
	cerr << "Unable to run: " << BinDir << "rc = " << sysrc << endl;
	return;
    }
    sprintf(TmpDir, "/tmp/%s/DuoToneTmpData.dat",IFO);
    sprintf(RES,    "/tmp/%s/Results.txt",IFO);
    sprintf(MatLog, "/tmp/%s/mat.log",IFO);

    sprintf(DataServer, "DuoTone_DataServer_%s",IFO);
    setServerName(DataServer);
    
    sprintf(TrendName, "DuoTone_%s",IFO);
    mTrendMinute.setName(TrendName);
    mTrendMinute.setFrameCount(1);   
    mTrendMinute.setType(Trend::kMinute);
    mTrendMinute.setAutoUpdate(false);
	    
    sprintf(trendChan_zSlsc, "%sLSC_SinSinZeroCrossing_us", trend);
    mTrendMinute.addChannel(trendChan_zSlsc);
    sprintf(trendChan_zSpem, "%sPEM_SinSinZeroCrossing_us", trend);
    mTrendMinute.addChannel(trendChan_zSpem);
    sprintf(trendChan_zRpem, "%sPEM_RampZeroCrossing_us", trend);
    mTrendMinute.addChannel(trendChan_zRpem);
    sprintf(trendChan_LSC, "%sLSC_TimingDifference_us", trend);
    mTrendMinute.addChannel(trendChan_LSC);
    sprintf(trendChan_ERR, "%sErrorFlag", trend);
    mTrendMinute.addChannel(trendChan_ERR);
    sprintf(trendChan_QAF, "%sSignalQualityFlag", trend);
    mTrendMinute.addChannel(trendChan_QAF);

#ifdef DEBUG_DUOTONE
    cout << "DuoTone channel watched : " << ChSlsc 
	 << "\n\n===========================\n\n" << endl;
#endif
    getDacc().setStride(40.0);             // Set the time step to 40 seconds
    getDacc().addChannel(ChSlsc);          // Add DuoTone Channel
    getDacc().addChannel(ChSpem);          // Add DuoTone Channel
    getDacc().addChannel(ChRpem);          // Add DuoTone Channel

    //mTrendMinute.addChannel(trend);
    sprintf(TrendTitle, "%s-DuoTone-Minute-Trend",IFO);
    serveData(trendChan_zSlsc,  
	      &(mTrendMinute.find(trendChan_zSlsc).refAvgSeries()), 
	      TrendTitle);
    serveData(trendChan_zSpem,  
	      &(mTrendMinute.find(trendChan_zSpem).refAvgSeries()), 
	      TrendTitle);
    serveData(trendChan_zRpem,  
	      &(mTrendMinute.find(trendChan_zRpem).refAvgSeries()), 
	      TrendTitle);
    serveData(trendChan_LSC,    
	      &(mTrendMinute.find(trendChan_LSC).refAvgSeries()), 
	      TrendTitle);
    serveData(trendChan_ERR, 
	      &(mTrendMinute.find(trendChan_ERR).refAvgSeries()), 
	      TrendTitle); 
    serveData(trendChan_QAF, 
	      &(mTrendMinute.find(trendChan_QAF).refAvgSeries()), 
	      TrendTitle);
    //serveData(trend, 
    //          &(mTrendMinute.find(trend).refAvgSeries()),
    //          "DUOTONE Minute Trend");
    //mTrendMinute.writeIndex();


//S--------------------- Defining the alarms
    const char* badTiming="../monitor_reports/DuoTone/";
    sprintf(AlarmMsg, "%s-LSC_Timing_Is_OFF",IFO);
    AlarmData al1("DUOTONE", AlarmMsg, Interval(120), 7, 
		  "Timing is bad", "");
    al1.setWebFile(badTiming);
    al1.jamFlags(AlarmData::kReTrigger);
    mAlarm.defineAlarm(al1);

    const char* NoSignal="../monitor_reports/DuoTone/";
    sprintf(AlarmMsg, "%s-DUOTONE_SIGNAL_IS_NOT_PRESENT",IFO);
    AlarmData al2("DUOTONE", AlarmMsg, Interval(120), 7, 
		  "No DUOTONE signal", "");
    al2.setWebFile(NoSignal);
    al2.jamFlags(AlarmData::kReTrigger);
    mAlarm.defineAlarm(al2);
//E--------------------- Defining the alarms

//B--------------------- Setting up EPICS stuff

    // Get environmental variable for CAPUT command...

    if (getenv("EPICSBINDIR") != 0) {
       strcpy(CaPutDir, getenv("EPICSBINDIR"));
    }

//E--------------------- Setting up EPICS stuff

}

DuoTone::~DuoTone() 
{
    cout << "DuoTone is finished" << endl;
}

void DuoTone::Attention(void) {
  MonServer::Attention();
}

void DuoTone::ProcessData(void) {                 // Decodes the time

    typedef short VecType;
    int i,j;
    double A1 = 1;
    double A2 = 0.75;
    double F1 = 960;
    double F2 = 961;
    double pi = 3.1415926;
    const int result_len =5;
    double Result[result_len];
    int B0 = 327680;
    Time GT;
    long int NanoSec;
    char  UTCtime[64];

    signal(SIGTTOU, SIG_IGN);

    ErrCode  = 0;
    QualCode =0;

    TSeries* tSlsc = getDacc().refData(ChSlsc);
    TSeries* tSpem = getDacc().refData(ChSpem);
    TSeries* tRpem = getDacc().refData(ChRpem);
	 
    tSlsc->Convert(DVecType<VecType>::getDataType());
    VecType* gSlsc = reinterpret_cast<VecType*>(tSlsc->refData());
    tSpem->Convert(DVecType<VecType>::getDataType());
    VecType* gSpem = reinterpret_cast<VecType*>(tSpem->refData());
    tRpem->Convert(DVecType<VecType>::getDataType());
    VecType* gRpem = reinterpret_cast<VecType*>(tRpem->refData());

    // Extract Signal Statistics...

    int    nSlsc = tSlsc->getNSample();      // Number of samples in the segment
    //double ASlsc = tSlsc->getAverage();      // Determine the zero offset
    //double MSlsc = tSlsc->getMaximum();      // Determine the maximum
    //double ISlsc = tSlsc->getMinimum();      // Determine the minimum
    //double RSlsc = MSlsc - ISlsc;            

    int    nSpem = tSpem->getNSample();      // Number of samples in the segment
    //double ASpem = tSpem->getAverage();      // Determine the zero offset
    //double MSpem = tSpem->getMaximum();      // Determine the maximum
    //double ISpem = tSpem->getMinimum();      // Determine the minimum
    //double RSpem = MSpem - ISpem;            

    int    nRpem = tRpem->getNSample();      // Number of samples in the segment
    //double ARpem = tRpem->getAverage();      // Determine the zero offset
    //double MRpem = tRpem->getMaximum();      // Determine the maximum
    //double IRpem = tRpem->getMinimum();      // Determine the minimum
    //double RRpem = MRpem - IRpem;           

    //B ----------------- Determines the midtime of the segment
    // Takes care of proper rounding of seconds	 
    GT= tSlsc->getBinT(B0);
    NanoSec = (long int) (GT.getN()/1000);
    if (NanoSec > 500000) {
      GT = GT + HalfSec;
      NanoSec -= 1000000;
    }

    // Converts to human readable time	 
#ifdef DEBUG_DUOTONE	 
    cout << "NanoSex: " << NanoSec << endl;
#endif    

    TimeStr(GT, UTCtime, "%D:%H:%N:%S");
#if 0
    int   sec=0,min=0,hour=0,day=0;
    char  da[4],ho[2],mi[2],se[2];
    TimeStr(GT, da, "%D");
    day = atoi(da);
    TimeStr(GT, ho, "%H");
    hour = atoi(ho);
    TimeStr(GT, mi, "%N");
    min = atoi(mi);
    TimeStr(GT, se, "%S");
    sec = atoi(se);
#endif
	       
    // Restores correct PPS edge time 			 
    if (NanoSec > 500000) {
      GT = GT - HalfSec;
    }
    //E ----------------- Determines the midtime of the segment

    // B: Basic checks on signal quality and presence

       // Do it whenever I have time...

    // E: Basic checks on signal quality and presence

    // Write data into file so Matlab can read it and there is a record of the data for debugging...

#ifdef DEBUG_DUOTONE
    cout << "Writing data file... " << TimeString(Now(), TIMESTR_FORMAT_DATE) 
	 << endl;
#endif

    ofstream TmpOut(TmpDir, ios::out | ios::binary);
    
    if (!TmpOut) {
        cerr << "Unable to open data output buffer file !";
	ErrCode += 1;
    }

    for (i=0; i<nSlsc; i++) {
      TmpOut.write((char *)(&gSlsc[i]), 2);
    }

    for (i=0; i<nSpem; i++) {
      TmpOut.write((char *)(&gSpem[i]), 2);
    }

    for (i=0; i<nRpem; i++) {
      TmpOut.write((char *)(&gRpem[i]), 2);
    }

    TmpOut.flush();
    TmpOut.close();

#ifdef DEBUG_DUOTONE
    cout << "Starting matlab module... " 
	 << TimeString(Now(), TIMESTR_FORMAT_DATE) << endl;
#endif

    if (system(COMM)) throw runtime_error("unable to exec COMM");

    // Start measurement

    double TT[Fs];  
    double SinS[Fs];

    double ds = 1/Fs;
    ds = 1/Fs;
    cout << Fs << " : " << ds << endl;
    double dt = 0;
    double tq = 1e-8;

    double mSlsc = 0;
    double mSpem = 0;

    double rmsSlsc = 1;
    double rmsSpem = 1;
    double g1[Fs];
    double g2[Fs];
    for (i=0; i<Fs; i++) {
      g1[i] = 0;
      g2[i] = 0;
    }

    for (i=0; i<nSlsc; i++) {
	j = int(i - Fs*floor(i/Fs));
	g1[j] += gSlsc[i];
	g2[j] += gSpem[i];
    }

    for (i=0; i<Fs; i++) {
      g1[i] /= (nSlsc/Fs);
      g2[i] /= (nSlsc/Fs);
      rmsSlsc += g1[i] * g1[i];
      rmsSpem += g2[i] * g2[i];
    }

    rmsSlsc = sqrt(rmsSlsc/nSlsc);
    rmsSpem = sqrt(rmsSpem/nSpem);
    for (i=0; i<Fs; i++) {
      g1[i] /= rmsSlsc;
      g2[i] /= rmsSpem;
    }

#ifdef DEBUG_DUOTONE
    cout << "Dual sinusoids are normalized: (lsc) "  << rmsSlsc 
	 << " (pem) " << rmsSlsc << endl;
#endif

    double rms = 1;
    for (i=0; i<Fs; i++) {
	TT[i]   = i * ds;
	SinS[i] = A1*sin(2*pi*F1*(TT[i])) + A2*sin(2*pi*F2*(TT[i]));
	rms += SinS[i] * SinS[i];
      }
    rms = sqrt(rms/Fs);

    double d1 = 0;
    double d2 = 0;
    double m1 = 1e100;
    double m2 = 1e100;
    cout << "loop: " << ceil(ds/tq) << " : " << ds << " : " << tq << endl;
    for (j=0; j<ceil(ds/tq); j++) {
      dt = -ds/2 + j*tq;
      d1 = 0;
      d2 = 0;
      for (i=0; i<Fs; i++) {
	TT[i]   = i * ds;
	SinS[i] = ( A1*sin(2*pi*F1*(TT[i]+dt)) + A2*sin(2*pi*F2*(TT[i]+dt)) ) / rms;
	d1 += ( g1[i] - SinS[i] ) * ( g1[i] - SinS[i] );
	d2 += ( g2[i] - SinS[i] ) * ( g2[i] - SinS[i] );
      }
   
#ifdef DEBUG_DUOTONE
      cout << d1 << " : " << d2 << endl;
#endif

      if (d1 < m1) {
	d1 = m1;
	mSlsc = dt;
      }
      if (d2 < m2) {
	d2 = m2;
	mSpem = dt;
      }
    }

#ifdef DEBUG_DUOTONE
      cout << "Time delay determined: (lsc)"  << mSlsc << " s {fit: " << d1 
	   << " } (pem) " << mSpem << " s {fit: " << d2 << " }" << endl;
#endif

    double g3[2*Fs];
    for (i=0; i<2*Fs; i++) {
      g3[i] = 0;
    }

    for (i=0; i<nRpem; i++) {
      j = i - 2*Fs*(int)floor(i/(2*Fs));
      g3[j] += gRpem[i];
    }
    
    double mRpem = 0;
    double d3 = 0;
    for (i=0; i<2*Fs; i++) {
      g3[i] /= nRpem / (2*Fs);
    }
    j = int(floor(Fs/2) - 20);
    for (i=0; i<Fs+40; i++) {
      if (g3[i+j]>d3) {
	mRpem = i+j;
	d3 = g3[i+j];
      }
    }
    mRpem = mRpem - 16;
    double d4 = 0;
    for (i=0; i<Fs/4; i++) {
      d4 += g3[(int)floor(mRpem - 100 - i)];
    }
    d4 = d4 / (Fs/4);
    for (i=0; i<2*Fs; i++) {
      g3[i] -= d4;
    }

    // End measurement

    ifstream Results(RES);
    
    if (!Results) {
        cerr << "Unable to open results file !";
	ErrCode += 2;
    }
    
    for (int i=0; Results >> Result[i] && i < result_len; i++);
    
    Results.close();
#ifdef DEBUG_DUOTONE
    cout << "Results: " << Result[3]
	 << " " << Result[2] 
	 << " " << Result[1]
	 << " " << Result[0]
	 << endl;
#endif

    //B---------------- Set error codes
    // ErrCode
    // QualCode
    //E---------------- Set error codes

    // Cleanup...
    int sysrc = system(CLEAN);
    if (sysrc) {
	cerr << "Cleanup command (" << CLEAN << ") failed" << endl;
    }

#ifdef DEBUG_DUOTONE
    cout << "Output directory was cleaned... "  
	 << TimeString(Now(), TIMESTR_FORMAT_DATE) << endl;
#endif

    //B---------------- Write minute trend
    //mTrendMinute.trendData(trend, GT, Result[3]);

      mTrendMinute.trendData(trendChan_zSlsc, GT, Result[0]);
      mTrendMinute.trendData(trendChan_zSpem, GT, Result[2]);
      mTrendMinute.trendData(trendChan_zRpem, GT, Result[1]);
      mTrendMinute.trendData(trendChan_LSC, GT, Result[3]);
      mTrendMinute.trendData(trendChan_ERR, GT, ErrCode);
      mTrendMinute.trendData(trendChan_QAF, GT, QualCode);

#ifdef DEBUG_DUOTONE
      cout << "Trend: " << trend << " => T = " << GT << " D = " << Result[3] 
	   << " | " << ErrCode << " | " << QualCode << endl;
#endif     
    //E---------------- Write minute trend

      //B---------------- Send data to EPICS
      if (Epics) {
	// EPICS communication by the minute...
     /*	ostringstream Comm0;
	Comm0 << CaPutDir << "/caput " << ALIVE_Ch << " " << abs((int)Alive) 
	      << " >> /dev/null 2>&1 \n";
	sysrc = system(Comm0.str().c_str()); 
	Alive+=128;

	time(&TS);
	ostringstream Com00;
	Com00 << CaPutDir << "/caput " << TTAG_Ch << " \" `date -u` \"   >> /dev/null 2>&1 \n";
	sysrc = system(Com00.str().c_str());
     */

	Alive+=128;
	ostringstream Comm;
	sprintf(EpicsComm, "%s/caput %sKEEPALIVE %d >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName, Alive);
	Comm << EpicsComm << endl;
	sprintf(EpicsComm, "%s/caput %sTTAG \" `tconvert now` \" >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName);
	Comm << EpicsComm << endl;
	sprintf(EpicsComm, "%s/caput %sLSC %4.3g >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName, Result[3]);
	Comm << EpicsComm << endl;
	sprintf(EpicsComm, "%s/caput %sACC %4.3g >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName, Result[4]);
	Comm << EpicsComm << endl;
	sprintf(EpicsComm, "%s/caput %sLSC_DUO %4.3g >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName, Result[0]);
	Comm << EpicsComm << endl;
	sprintf(EpicsComm, "%s/caput %sDAQ_RAMP %4.3g >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName, Result[1]);
	Comm << EpicsComm << endl;
	sprintf(EpicsComm, "%s/caput %sDAQ_DUO %4.3g >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName, Result[2]);
	Comm << EpicsComm << endl;
	sprintf(EpicsComm, "%s/caput %sERR_BITS %d >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName, ErrCode);
	Comm << EpicsComm << endl;
	sprintf(EpicsComm, "%s/caput %sQA_BITS %d >> /dev/null 2>&1 &", 
		CaPutDir, EpicsName, QualCode);
	Comm << EpicsComm << endl;

	sysrc = system(Comm.str().c_str());

#ifdef DEBUG_DUOTONE
	cout << "Sent to EPICS: " << Comm.str().c_str() << endl;
#endif

	/*
        sysrc = system(EpicsComm);
#ifdef DEBUG_DUOTONE
	cout << "Sent to EPICS: " << EpicsComm << endl;
#endif

	sprintf(EpicsComm, "%s/caput %sLSC %4.2g >> /dev/null 2>&1 \n", 
                CaPutDir, EpicsName, Result[3]);
	sysrc = system(EpicsComm);
#ifdef DEBUG_DUOTONE
	cout << "Sent to EPICS: " << EpicsComm << endl;
#endif


	H1:DMT-TM_TTAG           (GPS Time of measurement)
> H1:DMT-TM_KEEPALIVE      (keep alive channel, one per IFO)
>
> H1:DMT-TM_LSC            (GPS - LSC time difference, us)
> H1:DMT-TM_ACC            (Time measurement accuracy (error bar), ns)
> H1:DMT-TM_DAQ_RAMP       (Timing of ramp in adcu pem)
> H1:DMT-TM_DAQ_DUO        (Timing of duotone in adcu pem)
> H1:DMT-TM_LSC_DUO        (Timing of duotone in lsc)
> H1:DMT-TM_ERR_BITS       (Bit encoded error data)
> H1:DMT-TM_QA_BITS        (Bit encoded quality data)

	*/


	// ...end of epics communication...
#ifdef DEBUG_DUOTONE
	 cout << "Did EPICS communication..." << endl;
#endif	
      }
      //E---------------- Send data to EPICS

      //B---------------- Set alarms if necessary
      lmsg::error_t rc = 0;
      AlarmHandle han;

      if ( fabs(Result[3]) > 8 ) {

	ostringstream param;
	param << ChSlsc << " is off by: " << Result[3] << " us " << ends;
	sprintf(AlarmMsg, "%s-LSC_Timing_Is_OFF",IFO);
	AlarmData al1("DUOTONE", AlarmMsg, Interval(120), 7, 
		      "Timing is bad", param.str()); 
	rc = mAlarm.setAlarm(al1, han);
	if (rc) cerr << "[DuoTone] Error sending alarm: " << rc << endl;
#ifdef   DEBUG_DUOTONE
	cout << "ALARM: " << ChSlsc << " is off by: " << Result[3] << " us "
	     << endl;
#endif	
      }
      //E---------------- Set alarms if necessary
}
