#ifndef SEGEVAL_HH
#define SEGEVAL_HH

#include "calc_engine/engine.hh"
#include "LSCSegFind.hh"
#include "seg_stack.hh"
#include <map>

class SegEval : public Engine {
public:
  typedef std::map<std::string, LSCSegFind> dict_type;
public:
  SegEval(dict_type& t, const std::string& cmd, int debug=0);
  ~SegEval(void);
  const LockSegList& eval(void);
  virtual void eval_funct(const std::string& sym, int N);
  virtual void push_symbol(const std::string& sym);

private:
  dict_type& mDictionary;
  seg_stack  mStack;
};

#endif // !defined(SEGEVAL_HH)
