#include "SegEval.hh"
#include <stdexcept>
#include <sstream>
using namespace std;

//======================================  Command constructor
SegEval::SegEval(dict_type& d, const std::string& cmd, int debug)
  : Engine(mStack), mDictionary(d)
{
    istringstream str(cmd);
    Parse(str);
}

//======================================  SegEval destructor
SegEval::~SegEval(void) {
}

//======================================  Evaluate a segment
const LockSegList& 
SegEval::eval(void) {
    crank();
    if (mStack.size() != 1) throw runtime_error("Invalid command string");
    return dynamic_cast<seg_token&>(mStack.top()).refSegment();
}

//======================================  Evaluate a function
void 
SegEval::eval_funct(const std::string& sym, int N) {
    if (sym == "not") {
        dynamic_cast<seg_token&>(mStack.top()).refSegment().invert();
    } else if (sym == "now") {
        mStack.push(double(Now().getS()));
    } else if (sym == "seg") {
        double end   = mStack.pop_numeric();
	double start = mStack.pop_numeric();
	LockSegList l("Xn");
	l.insert(LockSegment(0, Time(long(start)), Time(long(end))));
	mStack.push(new seg_token(l));
    } else {
        throw runtime_error(string("Undefined function:") + sym);
    }
}

//======================================  
void 
SegEval::push_symbol(const std::string& sym) {
    if (mDictionary.find(sym) == mDictionary.end()) {
        throw runtime_error(string("Undefined segment: ") + sym);
    }
    mDictionary[sym].clear();
    mDictionary[sym].query();
    mStack.push(new seg_token(mDictionary[sym]));
}
