#ifndef BICOMON_HH
#define BICOMON_HH

// Debug Flag -- Define BM_DEBUG to display debug messages
// 
   //   Test for uniqueness then define/undefine as needed
   // #ifdef BM_DEBUG
   // cout << "WARNING:  BicoMon Debug Flag previously defined. Not unique."<<endl;
   // #undef BM_DEBUG
   // #endif

   //#define BM_DEBUG

#include "TSeries.hh"
#include "FixedLenTS.hh" 
#include "DatEnv.hh" 
#include "MonServer.hh"    // Monitor Data API 
#include "OperStateCondList.hh"
#include "BicoDir.hh"

const int fMaxMeas = 100;			// maximum number of measurements
const int fMaxConf = 20;				// maximum number of configurations
const int fMaxChan = 3 * fMaxConf;	// maximum number of channels



// Bicoherence Channel List
// ------------------------
// A unique list of the input channels and their parameters

class BicoChanList  {
 
   public:
     
     BicoChanList ()  ;      // Initialized a configuration record
     ~BicoChanList () ;      // Destroy a configuration record
  
     std::string 	fChanName; 		// Channel names
     Int_t			fDecim;			// Decimation (Set to 1 for now)
     
//     float  		fChanRate;     // Channel Data Rate 
//     float  		fFreqMax;    	// Frequency maximum     
};


// DECLARE BICOMON CLASS
// ---------------------
class BicoMon : public DatEnv, MonServer { 
   // inherit from DatEnv and MonServer 
   
   
   public: 
      BicoMon (int argc, const char* argv[]); 
      virtual ~BicoMon() {} 
      virtual void ProcessData(); 
      virtual void Attention() {    // Interrupt processing
      MonServer::Attention();    // Serve data if request pending
      } 
      

   private: 
//      TSeries*     	fData1[fMaxConf];    // Input time series 
//      TSeries*     	fData2[fMaxConf];    // Input time series 
//      TSeries*     	fData3[fMaxConf];    // Input time series 
      TSeries*	 	 	fDataUnique[fMaxChan];  // Why initialize so many??
      
      
      BicoDir*       fBicoData;           // Bicoherence of data
      std::string    fConfigFileName;     // Configuration File
      std::string    fResultsFileName;    // Results File
      int 			 	fNumMeas;			 	// Number of measurements
      int 			 	fNumConf;			  	// Number of configurations
      int 			 	fNumChanUnique;	  	// Number of unique channels
      BicoDirConf*   fBicoConf;           // Bicoherence Config Record
      int*           fMeasLimit;          // Range of measurements for each Config
      BicoMeas*		fMeas;		         // Measurement Records
      FixedLenTS*	 	fBicoTrendTS;	      // Trend of Bicoherence result
      bool* 		 	isTrendPadded;       // True if Trend TS padded
      float          fBicoSum;            // Sum over unique area of bicoherence
      const char* 	servedChannel;
      std::fstream   fResultsFile;
      std::fstream   fConfigFile;
      BicoChanList   fChanList[fMaxChan];
      float 		 	fSpanMax;
      bool				fOnline;		      	// True if live data
      std::string		fIFOname;				// IFO of the requested channels
      std::string		fIFOstate;				// State of the IFO 
      bool				fTestIFOstate;			// Check the State of the IFO?
      

      bool	OpenConfigFile();   	// Open parameters file
      bool 	ReadConfigFile();   	// Read monitor parameters
      bool 	StartResultsFile();	// Open and write header
      void  PrintConfig();       // Print Configuration Parameters for debugging
      bool 	FindUniqueChans();		// Select Unique Data Channels
      bool 	AssignDataChannels();	// 
      Int_t ChanMatch(std::string);
      
}; 

#endif
