//
//    Implementation of XSIL xsil_time object.
//
#include "PConfig.h"
#ifdef __GNU_STDC_OLD
#include <gnusstream.h>
#else
#include <sstream>
#endif
#include "xsil/xsil_time.hh"
#include "xsil/Xwriter.hh"
#include "Time.hh"
#include <cstdlib>

using namespace std;

namespace xsil {

//--------------------------------------  Null Constructor
xsil_time::xsil_time(void) {
}

//--------------------------------------  Data Constructor
xsil_time::xsil_time(const char* Name, const char* Type, const char* Value) 
  : xobj(Name, Type) {
    setValue(Value);
}

//--------------------------------------  Data Constructor
xsil_time::xsil_time(const char* Name, const Time& t) 
  : xobj(Name) {
    setValue(t);
}

//--------------------------------------  destructor
xsil_time::~xsil_time(void) {
}

//--------------------------------------  Write the object to an XML document
void
xsil_time::Spew(Xwriter& xout) const {
    const int   nattr=2;
    const char* attnames[]={"Name","Type"};
    const char* attstrings[]={getName(), getType()};
    xout.Tag(getObjType(), nattr, attnames, attstrings);
    xout.text(mValue);
    xout.endTag(getObjType());
}

//--------------------------------------  Return object type
xsil_time* 
xsil_time::Clone(void) const {
    return new xsil_time(getName(), getType(), getValue());
}

//--------------------------------------  Return object type
const char* 
xsil_time::getObjType(void) const {
    return "Time";
}

//--------------------------------------  Get the time value
Time
xsil_time::getTime(void) const {
    if (refType() == "GPS") return Time(strtol(mValue.c_str(), 0, 0));
    return Time(strtol(mValue.c_str(), 0, 0));
}

//--------------------------------------  Set the time value
void 
xsil_time::setValue(const char* Value) {
    if (Value) {
        mValue = Value;
	setType("GPS");
    }
}

//--------------------------------------  Set the time value
void 
xsil_time::setValue(unsigned int Value) {
    ostringstream out;
    out << Value;
    mValue = out.str();
    setType("GPS-sec");
}

//--------------------------------------  Set the time value
void 
xsil_time::setValue(const string& Value) {
    mValue = Value;
    setType("GPS");
}

//--------------------------------------  Set the time value
void 
xsil_time::setValue(const Time& Value) {
    // long long tval = Value.getS();
    // tval *= 1000000000;
    // tval += Value.getN();
    long tval = 0;
    tval = Value.getS();
    ostringstream out;
    out << tval;
    mValue = out.str();
    setType("GPS");
}

}
