/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "xsil/table.hh"
#include "xsil/Xwriter.hh"

using namespace xsil;
using namespace std;


//======================================  Default constructor
table::table(void) {
}

//======================================  Data constructor
table::table(const char* Name, const char* Type) 
  : xobj(Name, Type) 
{}

//======================================  Destructor
table::~table(void) {
    mColumn.erase(mColumn.begin(), mColumn.end());
}

//======================================  Output method
void
table::Spew(Xwriter& xout) const {
    const int   nattr=2;
    const char* attnames[]={"Name","Type"};
    const char* attstrings[]={getName(), getType()};
    xout.Tag(getObjType(), nattr, attnames, attstrings);
    xout.endLine();
    for (const_column_iterator i=mColumn.begin() ; i!=mColumn.end() ; i++) {
        i->Spew(xout);
    }
    mData.Spew(xout);
    xout.endTag(getObjType());
}

//======================================  Clone a table object
table* 
table::Clone(void) const {
    return new table(*this);
}

//======================================  Get object type
const char* 
table::getObjType(void) const {
    return "Table";
}

//======================================  Add a column
column* 
table::addColumn(const char* Name, const char* Type, const char* Unit){
    return addColumn(column(Name, Type, Unit));
}

//======================================  Add a column
column* 
table::addColumn(const column& x) {
    mColumn.push_back(x);
    return &mColumn.back();
}

//======================================  Return index of a column
int
table::findColumn(const std::string& name) const {
    int rv = 0;
    for (const_column_iterator i=mColumn.begin() ; i != mColumn.end() ; ++i) {
        if (name == i->getName()) return rv;
	rv++;
    }
    return -1;
}

//======================================  Read a row of data
void
table::readRow(vector<string>& v) {
    long N = mColumn.size();
    v.resize(N);
    bool sucks = mData.read(&v.front(), N);
    if (sucks) v.clear();
}

//======================================  Return a reference to a column
column& 
table::refColumn(const char* name) {
    std::string cName(name);
    for (column_iterator i=mColumn.begin() ; i != mColumn.end() ; i++) {
        if (cName == i->getName()) return *i;
    }
    return *mColumn.end();
}

//======================================  Return a reference to a column
const column& 
table::refColumn(const char* name) const {
    std::string cName(name);
    for (const_column_iterator i=mColumn.begin() ; i != mColumn.end() ; i++) {
        if (cName == i->getName()) return *i;
    }
    return *mColumn.end();
}

//======================================  Set the data stream
void 
table::setStream(const Stream& istr) {
    mData = istr;
}

//======================================  Set the data stream
void 
table::setUnit(const char* str) {
    mUnit = str;
}
