/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "xsil/column.hh"
#include "xsil/Xwriter.hh"

using namespace xsil;

//--------------------------------------  Default constructor
column::column(void) {
}

//--------------------------------------  Data constructor
column::column(const char *Name, const char* Type, const char* Unit) 
  : xobj(Name, Type) {
    setUnit(Unit);
}

//--------------------------------------  Destructor
column::~column(void) {
}

//--------------------------------------  Spew some XML
void
column::Spew(Xwriter& xout) const {
    const int   nattr=3;
    const char* attnames[]={"Name","Type","Unit"};
    const char* attstrings[]={getName(), getType(), mUnit.c_str()};
    xout.TagNData(getObjType(), nattr, attnames, attstrings);
}

//--------------------------------------  Object type?
column* 
column::Clone(void) const {
    return new column(getName(), getType(), getUnit());
}

//--------------------------------------  Object type?
const char* 
column::getObjType(void) const {
    return "Column";
}

//--------------------------------------  get units
const char* 
column::getUnit(void) const {
    return mUnit.c_str();
}

//--------------------------------------  set units
void 
column::setUnit(const char* Unit) {
    if (Unit) mUnit = Unit;
}
