/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef XSPECTRUM_HH
#define XSPECTRUM_HH
#include "xsil/ligolw.hh"

class FSpectrum;

namespace xsil {

/**  The %XSpectrum class is an xsil document containing a spectrum that
  *  meets Daniels xml specifications.
  *  This may be either manipulated as a separate document or added to
  *  an existing document with \e e.g.
  *  \verbatim
     ligolw doc;
     doc.addObject(new XSpectrum("Strain", fs));
  *  \endverbatim
  *  @memo Spectrum XSIL document
  *  @author J. Zweizig
  *  @version 1.0; Modified October 19, 2000
  *  @ingroup IO_xsil
  */
class XSpectrum : public ligolw {
public:
    /**  Construct a XSIL spectrum document for inclusion in an XSil document.
      *  \brief Spectrum document constructor.
      *  \param Name Spectrum object name attribute.
      *  \param fs   FSpectrum to be encoded into xsil.
      */
    XSpectrum(const char* Name, const FSpectrum& fs);

    /**  Destroy an XSpectrum.
      *  \brief Destructor
      */
    ~XSpectrum();
};

}

#endif  // XSPECTRUM_HH
