#include "lmsg/TCPSocket.hh"
#include "lmsg/SocketPool.hh"
#include "lmsg/ErrorList.hh"
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>

//======================================  Solaris posix sucks!
#include "sockfix.hh"

using namespace lmsg;

//======================================  Socket destructor
TCPSocket::~TCPSocket(void) {
    if (isConnected()) disconnect();
    close(mSocket);
}

//======================================  Constructor
TCPSocket::TCPSocket(const MsgAddr* addr) {
    mSocket = socket(PF_INET, SOCK_STREAM, 0);
    if (mSocket < 0) return;

    index_type rc = bind(addr);
    if (rc != OK) {
        close(mSocket);
	mSocket = -1;
    }
}

//======================================  Constructor
TCPSocket::TCPSocket(int ts) {
    mSocket = ts;
}

//======================================  Lend an ear
error_type
TCPSocket::listen(int nListen) {
    int rc = ::listen(mSocket, nListen);
    if (rc < 0) return SystemError;
    return OK;
}

//======================================  Wait for an incomming connection 
error_type
TCPSocket::waitConnect(wtime_type time, TCPSocket** ts) {
    if (!isOpen()) return NotOpen;

    
    error_type rc = wait(time);
    if (rc == Continue) rc = wait(0.0);
    if (rc != OK) return rc;

    ipsock_t tAddr;
    socklen_t len = sizeof(tAddr);
    int ls = ::accept(mSocket, reinterpret_cast<sockaddr*>(&tAddr), &len);
    if (ls < 0) return SystemError;
    mPartner = MsgAddr(tAddr);

    if (ts) {
        *ts = new TCPSocket(ls);
	(*ts)->mConnected = true;
	(*ts)->mPartner   = mPartner;
    } else {
        close(mSocket);
	mSocket = ls;
    }
    return OK;
}


//======================================  Disconnect
error_type 
TCPSocket::disconnect(void) {
    struct linger lpar;

    if (!mConnected) return OK;
    lpar.l_onoff  = true;
    lpar.l_linger = 5;
    int rc=::setsockopt(mSocket, SOL_SOCKET, SO_LINGER, &lpar, sizeof(lpar));
    if (rc < 0) return SystemError;
    mConnected = false;
    return OK;
}
