/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "lmsg/MsgHeader.hh"
#include "lmsg/Grinder.hh"
#include <iostream>

lmsg::MsgHeader::~MsgHeader(void) 
{}

lmsg::MsgHeader::MsgHeader(void) 
  : mLength(0), mType(0), mTransID(0), mBlockID(0) 
{}

lmsg::MsgHeader::MsgHeader(MsgType type, count_t length, const MsgAddr& dest)
  : mLength(length), mType(type), mDest(dest), mTransID(0), mBlockID(0)
{}

void
lmsg::MsgHeader::Dump(std::ostream& out) const {
    out << "Message Header:" << std::endl;
    out << "  Data Length         " << getMsgLength() << std::endl;
    out << "  Message Type        " << getMsgType() << std::endl;
    out << "  Source Address      " << getSource() << std::endl;
    out << "  Destination Address " << getDest() << std::endl;
    out << "  Transaction ID      " << getTransID() << std::endl;
    out << "  Block ID            " << getBlockID() << std::endl;
}

void
lmsg::MsgHeader::Export(void) {
    Import();
}

void
lmsg::MsgHeader::Import(void) {
    if (export_format_grinder.need_swap()) {
	export_format_grinder.SwapT(&mLength);
	export_format_grinder.SwapT(&mType);
	export_format_grinder.SwapT(&mTransID);
	export_format_grinder.SwapT(&mBlockID);
    }
}

void 
lmsg::MsgHeader::setDest(const MsgAddr& addr) {
    mDest = addr;
}

void 
lmsg::MsgHeader::setSource(const MsgAddr& addr) {
    mSource = addr;
}

void 
lmsg::MsgHeader::setMsgLength(count_t length) {
    mLength = length;
}

void 
lmsg::MsgHeader::setMsgType(MsgType type) {
    mType = type;
}

void 
lmsg::MsgHeader::setTransID(count_t id) {
    mTransID = id;
}

void 
lmsg::MsgHeader::setBlockID(count_t id) {
    mBlockID = id;
}
