#include "html/textAttr.hh"
#include "html/color.hh"
#include "html/size.hh"
#include "html/font.hh"

static const char* a_color = "color";
static const char* a_face  = "face";
static const char* a_size  = "size";

//======================================  Construct an empty textAttr list
html::textAttr::textAttr(void) {
}

//======================================  Get the text color
const html::color& 
html::textAttr::getColor(void) const {
    return dynamic_cast<const color&>(this->find(a_color));
}

//======================================  Get the text font
const html::font&  
html::textAttr::getFont(void) const {
    return dynamic_cast<const font&>(this->find(a_face));
}

//======================================  Get the text size
const html::size&  
html::textAttr::getSize(void) const {
    return dynamic_cast<const size&>(this->find(a_size));
}

//======================================  Set the text font face
void 
html::textAttr::setFont(const font& x) {
    addAttr(a_face, x);
}

//======================================  Set the text color
void 
html::textAttr::setColor(const color& x) {
    addAttr(a_color, x);
}

//======================================  Set the text size
void 
html::textAttr::setSize(const size& x) {
    addAttr(a_size, x);
}

//======================================  Merge an attribute list into this
void 
html::textAttr::merge(const textAttr& x) {
    if (!exists(a_color) && x.exists(a_color)) setColor(x.getColor());
    if (!exists(a_face)  && x.exists(a_face))  setFont (x.getFont());
    if (!exists(a_size)  && x.exists(a_size))  setSize (x.getSize());
}

//======================================  Remove default values
void 
html::textAttr::suppress(const textAttr& x) {
    if (exists(a_color)) {
        if (find(a_color).isDefault()) {
	    remAttr(a_color);
	} else if (x.exists(a_color) && getColor() == x.getColor()) {
	    remAttr(a_color);
	}
    }
    if (exists(a_face)) {
        if (find(a_face).isDefault()) {
	    remAttr(a_face);
	} else if (x.exists(a_face) && getFont() == x.getFont()) {
	    remAttr(a_face);
	}
    }
    if (exists(a_size)) {
        if (find(a_size).isDefault()) {
	    remAttr(a_size);
	} else if (x.exists(a_size) && getSize() == x.getSize()) {
	    remAttr(a_size);
	}
    }
}
