/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_LABEL_HH
#define HTML_LABEL_HH

#include "html/object.hh"
#include <time.h>
#include <string>

namespace html {
  class writer;

  /**  The label class tags a position in an HTML document that links
    *  to allow references by links. The label is ignored if it is not 
    *  assigned a value.
    *  @memo Mark a position.
    *  @author J. G. Zweizig
    *  @version 1.0; Modified May 29, 2001
    *  @ingroup IO_html
    */
  class label : public object {
  public:
    /**  Construct an empty label.
      *  @memo Default constructor.
      */
    label(void);

    /**  Construct a named label.
      *  @memo Data constructor.
      *  @param name Label name.
      */
    label (const std::string& name);

    /**  Destroy the label object.
      *  @memo Destructor.
      */
    ~label(void);

    /**  Create an identical label object and return a pointer.
      *  @memo Clone the label object.
      *  @return Pointer to the label clone.
      */
    label* clone(void) const;

    /**  Write the label to the specified html writer.
      *  @memo Write the label.
      *  @param out HTML write to which the label is to be written.
      */
    void write(writer& out) const;

    /**  Set the label name to the specified text.
      *  @memo Set the label text.
      *  @param txt New label name.
      */
    void setName(const std::string& txt);

  private:
    std::string mName;
  };
}

#endif  // HTML_LABEL_HH
