/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_IMAGE_HH
#define HTML_IMAGE_HH

#include "html/object.hh"
#include "html/Attrib.hh"
#include <string>

namespace html {
  class writer;

  /**  The IMAGE class represents an image to be displayed in the HTML
    *  document. The image object points to an image file of any standard
    *  type (gif, jpeg, etc.). 
    *  @memo Image object.
    *  @author J. Zweizig
    *  @version 1.0; Modified May 29, 2001
    *  @ingroup IO_html
    */
  class image : public object {
  public:
    /**  Construct an empty image.
      *  @memo Default constructor.
      */
    image(void);

    /**  Construct an image object referring to the specified source file.
      *  @memo Data constructor.
      *  @param src Image source file name.
      */
    image (const std::string& src);

    /**  Destroy the image object.
      *  @memo Destructor.
      */
    ~image(void);

    /**  Create an identical image object and return a pointer.
      *  @memo Clone the image object.
      *  @return Pointer to the image clone.
      */
    image* clone(void) const;

    /**  Write the image reference to the specified html writer.
      *  @memo Write the image.
      *  @param out HTML writer to which the line is to be written.
      */
    void write(writer& out) const;

    /**  Set the width (horizontal dimension) of the image to the 
      *  specified value.
      *  @memo Set the image width.
      *  @param w New image width.
      */
    void setWidth(const std::string& w);

    /**  Specify the location of the image source file.
      *  @memo Specify the image source.
      *  @param src Image source file location.
      */
    void setSource(const std::string& src);
  private:
    attList mAttr;
  };
}

#endif  // HTML_IMAGE_HH
