/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TABLE2C_HH
#define TABLE2C_HH

#include "html/table.hh"

class Time;

//======================================  2-column table utility class
namespace html {

    /**  Two column html table class.
      *  @author John Zweizig
      *  @version  1.1; Last modified March 4, 2008
      *  @ingroup IO_html
      */
    class Table2C : public table {
    public:
	/**  Construct a two-column table with the specified table name and
	  *  column headings.
	  *  @brief Two-column table constructor.
	  *  @param ttl   Table title.
	  *  @param c1ttl First column heading.
	  *  @param c2ttl Second column heading.
	  */
	Table2C(const char* ttl=0, const char* c1ttl=0, const char* c2ttl=0);

	/**  Destroy a two-column table.
	  *  @brief Destructor.
	  */
	virtual ~Table2C(void);

	/**  Add a row containing two strings.
	  *  @brief Add a row.
	  *  @param c1 String contents of first column.
	  *  @param c2 String contents of second column.
	  */
	void addRow(const std::string& c1, const std::string& c2);

	/**  Add a row containing a string and a number.
	  *  @brief Add a row.
	  *  @param c1 String content of first column.
	  *  @param c2 Numeric content of second column.
	  */
	void addRow(const std::string& c1, double c2);

	/**  Add a row containing a string and a time.
	  *  @brief Add a row.
	  *  @param c1  String content of first column.
	  *  @param c2  Time content of second column.
	  *  @param fmt TimeStr format for time conversion.
	  */
	void addRow(const std::string& c1, const Time& c2, const char* fmt=0);
    };
    
}  // namespace html

#endif   // TABLE2C_HH
