/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef FILE_STREAM_HH
#define FILE_STREAM_HH

#include <list>
#include <vector>
#include <string>

/**  The file stream class maintains a file stream and uses iNotify to 
 *  update the list with newly arriving frames.
 */ 
class file_stream {
public:
   typedef unsigned long gps_type;
public:
   /**  Default constructor for inactive file stream.
    */
   file_stream(void);

   /** Constructor a file_stream list.
    */
   explicit file_stream(const std::string& pattern, gps_type tStart=0);

   /**  Destructor for inactive file stream.
    */
   ~file_stream(void);

   /** Loop over files. Add those that match the pattern to the list.
    */
   void add_files(gps_type tStart=0);
   void add_watch(void);
   bool is_open(void) const;
   std::string next_file(void);
   void parse_pattern(const std::string& name);
   bool test_file(void);
   bool wait_file(void);
private:
   void insert_file(const std::string& pattern);
   void fetch_files(size_t pos, const std::string& path, gps_type t=0);
   bool match_pattern(const std::string& name, const std::string& pattern, 
		      gps_type t=0) const;
   bool open_notify(void);
   void pop_event(void);
   void push_event(const std::string& pattern);
   void replace_event(const std::string& pattern);
   bool read_event(void);
   bool test_event(void) const;
   int  wait_event(double tWait) const;
private:
   int  mNotifyFd;
   typedef std::pair<std::string, std::string::size_type> file_list_node;
   typedef std::list<file_list_node> file_list_type;
   typedef file_list_type::iterator file_list_iter;
   file_list_type file_list;
   
   std::vector<std::string> pattern_list;

   typedef std::pair<std::string, int>  event_list_node;
   typedef std::vector<event_list_node> event_list_type;
   typedef event_list_type::iterator    event_list_iter;
   event_list_type event_list;
};

//======================================  Inline methods
inline bool
file_stream::is_open(void) const {
   return mNotifyFd >= 0;
}
#endif // !defined(FILE_STREAM_HH)
