/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef FFERRORS_HH
#define FFERRORS_HH

#include <stdexcept>

//======================================  Error classes
/**  Bad file exception class
  *  @ingroup IO_futils
  */
class BadFile : public std::runtime_error {
public:
    /**  Construct a BadFile exception.
      *  @brief Constructor.
      */
     BadFile( const std::string& msg );
};

/**  No data exception class
  *  @ingroup IO_futils
  */
class NoData : public std::runtime_error {
public:
    /**  Construct a NoData exception.
      *  @brief Constructor.
      */
    NoData( const std::string& msg );
};

//======================================  Inline methods
inline
BadFile::BadFile( const std::string& msg )
        : std::runtime_error( msg )
{}

inline
NoData::NoData( const std::string& msg )
        : std::runtime_error( msg )
{}

#endif
