/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "FrameLenTab.hh"
#include <cstdlib>

using namespace std;

//======================================  Default constructor
FrameLenTab::FrameLenTab(void) {
}

//======================================  Default destructor
FrameLenTab::~FrameLenTab(void) {
    reset();
}

//======================================  Clear the symbol map
void 
FrameLenTab::reset(void) {
    mLenMap.clear();
}

//======================================  Default destructor
void 
FrameLenTab::addSym(const string& name, long val) {
    if (val == -1) val = 0;
    mLenMap.insert(len_node(name, val));
}

//======================================  Default destructor
bool 
FrameLenTab::parseType(const string& name, string& type, long& length) const {
    length = 1;
    type = name;
    string::size_type xpos = type.find("[");
    while (xpos != string::npos) {
	string::size_type epos = type.find("]");
	if (epos == string::npos) return false;
	string inxName(type.substr(xpos+1, epos-xpos-1));
	type.erase(xpos, epos+1-xpos);
	if (inxName[0] >= '0' && inxName[0] <= '9') {
	    length *= strtol(inxName.c_str(), 0, 0);
	} else {
	    len_map::const_iterator it = mLenMap.find(inxName);
	    if (it == mLenMap.end()) return false;
	    length *= it->second;
	}
	xpos = type.find("[");
    }
    return true;
}
