#include "PConfig.h"
#include "framefast/framefast.hh"
#include "framedir.hh"
#include "Time.hh"
#include "goption.hh"
#include <stdlib.h>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <vector>
#ifdef __GNU_STDC_OLD
#define left ""
#define right ""
#endif
#

   using namespace framefast;
   using namespace gdsbase;
   using namespace std;

   const char* dtype[5] = {"ADC", "Proc", "Sim", "Ser", "Summary"};

   int main (int argc, char** argv)
   {
      // parse cmd line arguments
      vector<string> filenames;
      option_string opt (argc, argv, "hscemd");
      if (opt.opt ('h') || (opt.argbegin() == opt.argend())) {
         cout << "usage: finfo [-s | -c | -C | -m] [-e] 'framefile'" << endl;
         cout << "       -s : summary list" << endl;
         cout << "       -c : channel list" << endl;
         cout << "       -e : extended listing" << endl;
         cout << "       -m : dictionary information" << endl;
         cout << "       -d : debugging information" << endl;
         exit (0);
      }
      bool chnlist = opt.opt ('c');
      bool extended = opt.opt ('e');
      bool meta = opt.opt('m');
      bool debug = opt.opt('d');
   
      for (option_string::arg_list::const_iterator i = opt.argbegin(); 
          i != opt.argend(); ++i) {
	 if (debug) cout << "finfo: Input argument: " << *i << endl;
         filenames.push_back (*i);
      }
   
      // add filenames to frame dir
      FrameDir fdir;
      for (vector<string>::iterator i = filenames.begin(); 
          i != filenames.end(); ++i) {
         fdir.add (i->c_str(), true);
      }
   
      // print frame information
      for (FrameDir::file_iterator i = fdir.begin(); i != fdir.end(); ++i) {
         string file = i->getFile();
	 if (debug) cout << "finfo: Load file: " << file << endl;
         framereader fr;
         if (fr.loadFile (file.c_str())) {
            if (chnlist) {
               const toc_t* toc = fr.getTOC();
	       if (!toc) {
		  cout << "finfo: Table of contents not found" << endl; 
		  continue;
	       }
               for (int j = 0; j < 5; ++j) {
		  if (debug) cout << "finfo: Dumping " << toc->fNData[j] << " " 
				  << dtype[j] << " structures." << endl;
                  for (unsigned int i = 0; i < toc->fNData[j]; ++i) {
                     if (extended) {
                        cout << setw (32) << left << toc->fData[j][i].fName;
                        data_t adcinfo;
                        if (fr.getData (adcinfo, 
                                       toc->fData[j][i].fPosition[0], (datatype_t)j, 
                                       framefast::frvect_t::fv_nocopy)) {
                           cout << " " << setw (6) << right << 
                              adcinfo.fADC.fSampleRate << endl;
                        }
                     }
                     else {
                        cout << toc->fData[j][i].fName << endl;
                     }
                  }
               }
            }
            else if (meta) {
               dict_t dict;
               if (!fr.getDict (dict)) {
                  cout << "Dictionary unavailable" << endl;
               }
               else {
                  // write list of dictionary header 
                  cout << setw (20) << left << "Header" << 
                     setw (5) << right << "ID" << 
                     setw (3) << " " << 
                     setw (30) << left << "Comment" << 
                     setw(5) << right << "#" << endl;
                  for (unsigned int i = 0; i < dict.fDictNum; ++i) {
                     cout << setw (20) << left << (string ("\"") + 
                                          string (dict.fDict[i].fName) + "\",") <<
                        setw(5) << right << dict.fDict[i].fClassNum << 
                        setw (3) << left  << "," <<
                        setw(30) << left << (string ("\"") + 
                                          string (dict.fDict[i].fComment) + "\",") <<
                        setw(5) << right << dict.fDict[i].fElementNum << 
                        setw(1) << left << "," << endl;
                  }
                  // write a list of elements for each header
                  for (unsigned int i = 0; i < dict.fDictNum; ++i) {
                     dict_header_t* h = dict.fDict + i;
                     // write a list of elements
                     cout << endl;
                     cout << setw (20) << left << h->fName << 
                        setw (16) << left << "Type" << 
                        setw (30) << left << "Comment" << endl;
                     for (unsigned int j = 0; j < h->fElementNum; ++j) {
                        cout << setw (20) << left << (string ("\"") +
                                             h->fElements[j].fName + "\",") << 
                           setw (16) << left << (string ("\"") +
                                             h->fElements[j].fType + "\",") << 
                           setw (1) << left << (string ("\"") +
                                             h->fElements[j].fComment + "\",") << endl;
                     }
                  }
               }
            }
            else {
               cout << "File             = " << file << endl;
               cout << "File length      = " << fr.length() << " B" << endl;
               Time start = fr.starttime();
               char buf[1024];
               TimeStr (start, buf, "%Y, %M %d, %H:%N:%S");
               Interval duration = fr.starttime(fr.nframe()-1) + 
                  fr.duration(fr.nframe()-1) - start;
               cout << "Start time       = " << start.getS() << " GPS   " << 
                  buf << " UTC" <<  endl;
               cout << "Duration         = " << (double) duration << " sec" << endl;
               if (extended) {
                  cout << "Frame length     = " << fr.duration(0) << " sec" << endl;
                  cout << "Number of frames = " << fr.nframe() << endl;
                  const toc_t* toc = fr.getTOC();
                  cout << "Number of ADCs   = " << toc->fNData[0] << endl;
                  cout << "Number of Procs  = " << toc->fNData[1] << endl;
                  cout << "Number of Sims   = " << toc->fNData[2] << endl;
                  cout << "Number of Sers   = " << toc->fNData[3] << endl;
               }
            }
         }
	 else {
	    if (debug) cout << "finfo: Failed to load file: " << file << endl;
	 }
      }
   
      return 0;
   }
