
#include "framefast/framefast.hh"
#include "Time.hh"
#include <stdlib.h>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include <vector>

   using namespace framefast;
   using namespace std;



   int main (int argc, char** argv)
   {
      // parse cmd line arguments
      int 		c;
      extern int	optind;	
      int		errflag = 0;
      bool 		ascii = false;
      int		fnum = 0;
      string		channel;
      string		ifilename;
      string		ofilename;
      while ((c = getopt (argc, argv, "hn:a")) != EOF) {
         switch (c) {
            case 'a':
               {
                  ascii = true;
                  break;
               }
            case 'n':
               {
                  fnum = atoi (optarg);
                  break;
               }
            case 'h':
               {
                  errflag = 1;
                  break;
               }
         }
      }
      if (errflag || (argc != optind + 3)) {
         cout << "usage: fextract [options] 'channel' 'framefile' 'outfile'" << endl;
         cout << "       -a : ASCII data (instead of binary float)" << endl;
         cout << "       -n 'num' : frame number (default 0)" << endl;
         exit (0);
      }
      channel = argv[optind];
      ifilename = argv[optind + 1];
      ofilename = argv[optind + 2];
   
      framereader fr;
      if (!fr.loadFile (ifilename.c_str())) {
         cerr << "Unable to open frame file '" << ifilename << "'" << endl;
         exit (1);
      }
      ofstream out (ofilename.c_str());
      if (!out) {
         cerr << "Unable to open output file '" << ofilename << "'" << endl;
         exit (1);
      }
      data_t dat;
      if (!fr.getData (dat, channel.c_str(), fnum, frvect_t::fv_original)) {
         cerr << "Unable to read '" << channel << "' (fnum = " << 
            fnum << ")" << endl;
         exit (1);
      }
      int len = dat.fVect.fNData;
      real_4_t* y = new real_4_t[2 * len];
      len = dat.fVect.get (y, 2 * len);
      if (len <= 0) {
         cerr << "Unable to obtain data for '" << channel << "'" << endl;
         exit (1);
      }
      if (ascii) {
         for (int i = 0; i < len; ++i) {
            out << y[i] << endl;
         }
      }
      else {
         out.write ((const char*)y, len * sizeof (real_4_t));
      }
      delete [] y;
      out.close();
      return 0;
   }
