/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "dfm/dfmsends.hh"
#include "fantom/fchannel.hh"
#include "fantom/sendsio.hh"
#include <iostream>
#include <sstream>
#include <cstring>
#include <cstdlib>

#define SENDS_UDNPFX_STR "nds2://"
#define SENDS_UDNPFX_LEN 7

namespace dfm {
   using namespace std;
   using namespace fantom;


   // 5s timeout
   static const int _TIMEOUT = 5000000;	
   // Default NDS port
   static const int kSENDSPORT = 31200;



//////////////////////////////////////////////////////////////////////////
//                                                                      //
// dfmsends							        //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
   dfmsends::dfmsends () : fPort (0)
   {
      fChnPreselFull = true;
   }

//______________________________________________________________________________
   bool dfmsends::open (const std::string& addr, bool read)
   {
      fAddr = addr;
      string::size_type pos = fAddr.find (":");
      if (pos != string::npos) {
         fServer = fAddr.substr (0, pos);
         fPort = atoi (fAddr.c_str() + pos + 1);
      }
      else {
         fServer = fAddr;
         fPort = kSENDSPORT;
      }
      for (string::iterator i = fServer.begin(); 
          i != fServer.end(); ++i) {
         *i = tolower (*i);
      }
      while (!fServer.empty() && isspace (fServer[0])) {
         fServer.erase (0, 1);
      }
      while (!fServer.empty() && 
            isspace (fServer[fServer.size()-1])) {
         fServer.erase (fServer.size() - 1);
      }
      return true;
   }

//______________________________________________________________________________
   void dfmsends::close()
   {
      fAddr = "";
   }

//______________________________________________________________________________
   bool dfmsends::requestUDNs (UDNList& udn)
   {
      ostringstream buf;
      buf << SENDS_UDNPFX_STR << fServer;
      if (fPort != kSENDSPORT) {
         buf << ":" << fPort;
      }
      //udn.clear();
      string s = buf.str() + "/frames";
      udn.insert (UDNList::value_type (UDN (s.c_str()), UDNInfo()));
      s = buf.str() + "/trend";
      udn.insert (UDNList::value_type (UDN (s.c_str()), UDNInfo()));
      s = buf.str() + "/minute-trend";
      udn.insert (UDNList::value_type (UDN (s.c_str()), UDNInfo()));
      return true;
   }

//______________________________________________________________________________
   bool dfmsends::requestUDNInfo (const UDN& udn, UDNInfo& info)
   {
      // build UDN info
      //cerr << "ask for UDN info" << endl;
      frametype utype = NONE;
      const char* p = udn;
      if (!p || strncasecmp (p, SENDS_UDNPFX_STR, SENDS_UDNPFX_LEN)) {
         return false;
      }
      p += SENDS_UDNPFX_LEN;
      while (*p && (*p != '/')) p++;
      if (strcasecmp (p, "/frames") == 0) {
         utype = FF;
      }
      else if (strcasecmp (p, "/trend") == 0) {
         utype = STF;
      }
      else if (strcasecmp (p, "/minute-trend") == 0) {
         utype = MTF;
      }
      else {
         return false;
      }
      UDNInfo uinfo;
      uinfo.setType (utype);
      // get channel names
      channellist chns;
      if (!sends_support::getChannels (fServer.c_str(), fPort, chns, utype)) {
	 cerr << "Can't get channels for " << fServer << ":" << fPort << endl;
         return false;
      }
      uinfo.setChannels (chns);
      // get times
      Time start;
      Time stop;
      //cerr << "ask for time" << endl;
      if (!sends_support::getTimes (fServer.c_str(), fPort, start, 
                           stop, utype)) {
	 cerr << "Can't get times for " << fServer << ":" << fPort << endl;
         return false;
      }
      //cerr << "ask for time done" << endl;
      if (stop > start) {
         uinfo.insertDSeg (start, stop - start);
      }
      info = uinfo;
      return true;
   }


}
