VCSID("$(#)$Id: diagtest.cc 7338 2015-04-14 23:24:47Z ed.maros@LIGO.ORG $");

#include <time.h>
#include <iostream> // JCB
#include "dtt/diagtest.hh"
#include "dtt/diagdatum.hh"

namespace diag {
   using namespace std;
   using namespace thread;

int diagtest::instance_count = 0 ; // JCB

   double diagtest::measurementTime (double duration, double cycles, 
                     double f, bool roundup)
   {
      double		mTime;
   
      if (f <= 0) {
         return -1;
      }
      if (duration > 0) {
         if (cycles > 0) {
            mTime = max (duration, cycles / f);
         }
         else {
            mTime = duration;
         }
      }
      else if (cycles > 0) {
         mTime = cycles / f;
      }
      else {
         return -1;
      }
      if (roundup) {
         int nc = (int) (mTime * f + 0.999999);
         mTime = (double) nc / f;
      }
      if (mTime < 1 / f) {
         mTime = 1 / f;
      }
      return mTime;
   }


   double  diagtest::adjustForSampling (double duration, double dt)
   {
      double		ns;
   
      if (dt <= 0) {
         return -1;
      }
      else if (fabs (duration) < 1E-6) {
         return 0;
      }
      else if (modf (duration / dt, &ns) > 0.000001) {
         return dt * (ns + 1);
      }
      else {
         return duration;
      }
   }


   tainsec_t  diagtest::fineAdjustForSampling (tainsec_t t, double dt)
   {
      int	rate = (int) (1.0/dt + 0.5);
   
      if (rate <= 1) {
         tainsec_t 	step = (tainsec_t) (dt + 0.5);
         tainsec_t	time = (t + _ONESEC / 2) / _ONESEC;
         return step * (time / step) * _ONESEC;
      }
      else {
         tainsec_t	time = t / _ONESEC;
         tainsec_t	rest = t % _ONESEC;
         tainsec_t	step = _ONESEC / rate;
         return (time * _ONESEC +
                _ONESEC * ((rest + step / 2) / step) / rate);
      }
   }



   diagtest::~diagtest () 
   {
      setEnvironmentExcitationManager (0);
      { // JCB
//	 char str[128] ;
//	 sprintf(str, "diagtest instance %d destroyed\n", myinstance) ;
//	 cerr << str ;
      }
   }


   bool diagtest::init (diagStorage& Storage, 
                     const cmdnotify& Notify,
                     dataBroker& databroker,
                     excitationManager& EnvExc,
                     excitationManager& TestExc,
                     int KeepTraces, bool rtMode)
   {
      semlock 		lockit (mux);
   
      storage = &Storage;
      notify = Notify;
      dataMgr = &databroker;
      setEnvironmentExcitationManager (&EnvExc);
      testExc = &TestExc;
      keepTraces = KeepTraces;
      RTmode = rtMode;
   
      return true;
   }


}
