void 
TPlot(const char *name, const char *opts=0) {
    TSeries* ts = In.refData(name);
    if (!ts) {
        printf("TPlot: Could not find Time series for channel %s.\n", name);
	return;
    }
    TPlot(ts, opts);
}

void 
TPlot(const TSeries* ts, const char* opts=0) {
    //----------------------------------  Formatting parameters
    float ymargin = 0.1;  // Fractional margin in y.

    if (!ts) {
        printf("TPlot: Invalid TSeries pointer.");
	return;
    }

    //----------------------------------  Get the TSeries parameters.
    int nbin = ts->getNSample();
    float stime = ts->getStartTime().totalS();
    if (stime > 1000000.0) stime = 0;
    float step  = ts->getTStep().GetSecs();

    //----------------------------------  Get the data and real length.
    float* DVec = new float[nbin];
    int nwd = ts->getData(nbin,DVec);
    float dtime = stime + step * nwd;

    //----------------------------------  Create and fill the histogram.
    TH1F hist("TS001", ts->getName(), nwd, stime, dtime);
    float ymin = DVec[0];
    float ymax = DVec[0];
    for (int i=0 ; i<nwd ; i++) {
        //-----------------------------  Histogram content in bins 1-N. Bin 0
        //                               has UnderFlow, bin N+1 has OverFlow
        hist.SetBinContent(i+1, DVec[i]);
	if (DVec[i] < ymin) ymin = DVec[i];
	if (DVec[i] > ymax) ymax = DVec[i];
    }
    delete[] DVec;
    float yavg = 0.5 * (ymin + ymax);
    float ydif = yavg - ymin;
    ymin = yavg - (1.0 + ymargin)*ydif;
    ymax = yavg + (1.0 + ymargin)*ydif;
    if (ymin < 0.0 && yavg-ydif >= 0.0) ymin = 0.0;
    hist.SetMinimum(ymin);
    hist.SetMaximum(ymax);

    //----------------------------------  Set the plotting options
    gStyle->SetOptStat(0);
    if (gROOT->GetSelectedPad()) (gROOT->GetSelectedPad()->GetCanvas())->cd();
    else                         new TCanvas("cGDS", "GDS Canvas");
    if (gROOT->FindObject("padT")) delete gROOT->FindObject("padT");
    TPad* padT = new TPad("padT", "Time Series", 0.0, 0.0, 1.0, 1.0);
    padT->Draw();
    padT->cd();
    padT->SetBottomMargin(0.12);
    padT->SetLeftMargin(0.15);
    padT->SetTicks(1,1);
    hist.DrawCopy(opts);

    //----------------------------------  Label axes
    TText l1;
    l1.SetTextAlign(22);
    l1.SetTextSize(0.05);
    l1.SetTextAngle(90.);
    l1.DrawTextNDC(0.03, 0.50, "ADC Signal (adc units)");

    l1.SetTextAngle(0.);
    l1.DrawTextNDC(0.50, 0.03, "Time (seconds)");

    padT->GetCanvas()->Update();
}
