/* -*-  mode: c++; c-basic-offset: 4; -*- */
#include "eval_stack.hh"
#include <stdexcept>
#include <iostream>

using namespace std;

//======================================  Eval stack class
bool 
eval_token::getLogical(void) const {
    throw logic_error("Boolean data types not implemented");
}

double 
eval_token::getNumeric(void) const {
    throw logic_error("Numeric data types not implemented");
}

void 
eval_token::setLogical(bool yorn) {
    throw logic_error("Boolean data types not implemented");
}

void 
eval_token::setNumeric(double val) {
    throw logic_error("Numeric data types not implemented");
}

//======================================  Eval stack constructor
eval_stack::eval_stack(void) {
    for (int i=0; i<kNOps; ++i) mOpLevel[i] = 0;
    mOpLevel[kNoop]   = 5;
    mOpLevel[kMpy]    = 1;
    mOpLevel[kDiv]    = 1;
    mOpLevel[kAdd]    = 2;
    mOpLevel[kSub]    = 2;
    mOpLevel[kAnd]    = 2;
    mOpLevel[kOr]     = 2;
    mOpLevel[kCmpEq]  = 3;
    mOpLevel[kCmpNE]  = 3;
    mOpLevel[kCmpLt]  = 3;
    mOpLevel[kCmpLE]  = 3;
    mOpLevel[kCmpGt]  = 3;
    mOpLevel[kCmpGE]  = 3;
    mOpLevel[kLogAnd] = 4;
    mOpLevel[kLogOr]  = 4;
    mOpLevel[kModulo] = 1;

    for (int i=0; i<kNOps; ++i) mOpStr[i] = 0;
    mOpStr[kMpy]    = "*";
    mOpStr[kDiv]    = "/";
    mOpStr[kAdd]    = "+";
    mOpStr[kSub]    = "-";
    mOpStr[kAnd]    = "&";
    mOpStr[kOr]     = "|";
    mOpStr[kCmpEq]  = "==";
    mOpStr[kCmpNE]  = "!=";
    mOpStr[kCmpLt]  = "<";
    mOpStr[kCmpLE]  = "<=";
    mOpStr[kCmpGt]  = ">";
    mOpStr[kCmpGE]  = ">=";
    mOpStr[kLogAnd] = "&&";
    mOpStr[kLogOr]  = "||";
    mOpStr[kModulo] = "%";
}

//======================================  Destroy Eval stack
eval_stack::~eval_stack(void) {
    clear();
}

//======================================  Eval stack Dump
void 
eval_stack::dump(std::ostream& out) const {
    out << "-----------------  Stack Dump, size=" << size() << endl;
    for (int inx=size(); inx; --inx) {
        out << inx-1 << "  type=" << mVect[inx-1]->getType() << "  "
	    << mVect[inx-1]->getString() << endl;
    }
}

//======================================  Perform operation on the top 
//                                        elements of the stack.
void 
eval_stack::evaluate(OpsEnum op) {
    throw logic_error("Stack operations aren't defined.");
}

//======================================  Operator database 
eval_stack::OpsEnum 
eval_stack::getOpID(const string& op) const {
    for (int i=0; i<kNOps; ++i) {
	if (mOpStr[i] && op == mOpStr[i]) return OpsEnum(i);
    }
    throw runtime_error("Invalid operator");
}

eval_stack::op_level 
eval_stack::getOpLevel(OpsEnum op) const {
    return mOpLevel[op];
}

const char* 
eval_stack::getOpSym(OpsEnum op) const {
    return mOpStr[op];
}

//======================================  Eval stack push operators
void 
eval_stack::push(const eval_token& tkn) {
    push(tkn.clone());
}

void 
eval_stack::push(eval_token* tkn) {
    mVect.push_back(tkn);
}

void 
eval_stack::push(const string& str) {
    throw logic_error("push(string) not implemented");
}

void 
eval_stack::push(double val) {
    throw logic_error("push(double) not implemented");
}

void 
eval_stack::push(bool val) {
    throw logic_error("push(bool) not implemented");
}


//======================================  Eval stack pop operators
bool 
eval_stack::pop_logical(void) {
    if (empty()) throw logic_error("Attempt to pop off empty stack");
    bool rc = top().getLogical();
    remove();
    return rc;
}

double 
eval_stack::pop_numeric(void) {
    if (empty()) throw logic_error("Attempt to pop off empty stack");
    double rc = top().getNumeric();
    remove();
    return rc;
}

std::string 
eval_stack::pop_string(void) {
    if (empty()) throw logic_error("Attempt to pop off empty stack");
    string r = top().getString();
    remove();
    return r;
}

//======================================  Eval stack peek operators
const eval_token&
eval_stack::peek(int off) const {
    int inx = mVect.size();
    if (off <= 0 || off > inx) throw logic_error("Invalid offset");
    inx -= off;
    return *mVect[inx];
}

eval_token::datype 
eval_stack::type(int off) const {
    int inx = mVect.size();
    if (off <= 0 || off > inx) throw logic_error("Invalid offset");
    inx -= off;
    return mVect[inx]->getType();
}
