#ifndef TRIG_TEMPLATE_HH
#define TRIG_TEMPLATE_HH

#include "TrigEnv.hh"
class TSeries;

/**  Trigger directed processing template class. This class demonstrates 
  *  how a program can be set up to reprocess data near a set of recorded
  *  triggers. Monitors based on TrigEnv are very similar to those based
  *  on DatEnv with the exception that the TrigEnv base class reads a series
  *  of discreet data "epochs" whereas the DatEnv class reads an infinite
  *  stream of data. The data epochs are defined relative to the start times 
  *  of a series of triggers (provided as a table).
  *  @author John Zweizig.
  *  @version 1.0; July 3, 2001
  */
class TrigTemplate : public TrigEnv {
public:

  /**  The monitor constructor receives the list of command line arguments
    *  in the usual form.
    *  @memo Monitor constructor.
    *  @param argc Number of arguments specified on the command line.
    *  @param argv An array of pointers to command argument strings.
    */
  TrigTemplate(int argc, const char* argv[]);

  /**  The monitor destructor is used to report statistics and to free any
    *  memory allocated by the monitor functions.
    *  @memo Monitor destructor.
    */
  ~TrigTemplate(void);

  /**  This is the user-supplied method to perform any monitor-specific 
    *  data processing.
    *  @memo Data Pocessing method.
    */
  void ProcessData(void);

  /**  This is a user supplied method to process and select the triggers 
    *  that are read in. Each trigger that is read in is passed to 
    *  ProcessTrigger. The ProcessTrigger return value specifies whether 
    *  data epoch defined relative to the trigger start time (or set 
    *  explicitely by ProcessTrigger) is to be read in for processing by 
    *  ProcessData.
    *  @memo Process and select a trigger.
    *  @param t Trigger to be examined and selected.
    *  @return true if the data epoch is to be passed to ProcessData.
    */
  bool ProcessTrigger(const trig::TrigBase& t);

private:

  TSeries* mSeisx;
};
#endif  // TRIG_TEMPLATE_HH
