#ifndef _DMTIFC_H_
#define _DMTIFC_H_

#ifdef __cplusplus
extern "C" {
#endif

struct FrameH;
/* #include "FrameL.h" */

/**  @name DMT C Interface
  *  #DMTifc.h#  provides a C callable interface for those wishing to
  *  use C code in the data monitor. The C API is implemented as a thin
  *  layer over the C++ frame environment and the function names and 
  *  arguments are kept as similar as possible to the C++ versions. 
  *  The hooks will be added to make any new functionality available 
  *  in the C++ class.
  *  @memo C language API.
  *  @author John G. Zweizig
  *  @version 1.2 ; Last modified: April 12, 1999
  */
/*@{*/
/**  #DMT_Initialize# is a user supplied C function to perform monitor
  *  specific initialization. #finish# may be called to stop the 
  *  process immediately if an error occurs during initialization.
  *  @memo Monitor Initialization function (User supplied).
  *  @param argc Number of arguments specified.
  *  @param argv address of vector of pointers to arguments.
  */
void DMT_Initialize(int argc, const char *argv[]);

/**  #DMT_Halt# is a user supplied C function to perform monitor specific
  *  end-of-task processing.
  *  @memo Monitor shut down (User supplied).
  */
void DMT_Halt(void);

/**  #DMT_Frame# is a user supplied C function to perform monitor specific 
  *  processing of one data frame. A pointer to the frame to be processed 
  *  is passed as an argument.
  *  @memo Process a data frame (User supplied).
  *  @param Pointer to the frame to be processed (FL format).
  */
void DMT_Frame(const void* frame);

/**  #DMT_Attention# is a user supplied C function that performs any 
  *  attention interrupt processing appropriate for the monitor. Attention 
  *  processing may include updating parameters or generating reports.
  *  @memo Handle an attention interrupt (User supplied).
  */
void DMT_Attention(void);

/**  #Boundary# returns true if the current frame is not contiguous with
  *  the frame previously processed. #Boundary# is always true 
  *  (non-zero) for the first frame processed.
  *  @memo Test for a boundary between contiguous segments.
  *  @return Non-zero if the last frame read was a boundary frame.
  */
int  Boundary(void);

/**  #Debug# returns the debug level specified by the "-debug <n>" command
  *  line argument.
  *  @memo   Get the debug level.
  *  @return The debug level.
  */
int Debug(void);

/**  #finish# notifies the main loop that it should terminate. 
  *  Note: control is always returned to the calling function (usually
  *  #DMT_Frame#) which must return normally.
  *  @memo Tell the main loop we're done.
  */
void finish(void);

/**  #getNFrames# returns the number of frames that have been read 
  *  by the base routines. It returns 1 while the first frame is being 
  *  processed.
  *  @memo Get the number of frames processed.
  *  @return The number of frames read.
  */
int  getNFrames(void);

/**  #getNContig# returns the number of contiguous segments found while 
  *  processing the frame stream.
  *  @memo Get the number of contiguous segments found.
  *  @return The number of boundary frames that have been encountered.
  */
int  getNContig(void);

/*@}*/
#ifdef __cplusplus
	   }
#endif

#endif  /* _DMTIFC_H_  */
