/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "DMTServer.hh"
#include <string>
#include <iostream>
#include <unistd.h>
#include <cstdlib>

using namespace std;

//======================================  DMTServer construtor.
DMTServer::DMTServer(int argc, const char* argv[]) 
  : MonServer(), mActive(false), mReschedule(300.0), mWakeup(0), mDebug(0)
{
    for (int i=1; i<argc; ++i) {
        string argi = argv[i];
        if (argi == "-debug") {
	    mDebug = strtol(argv[++i], 0, 0);
	} else if (argi == "-dt") {
	    mReschedule = strtod(argv[++i], 0);
	} else if (argi == "-name") {
	    MonServer::setServerName(argv[++i]);
	}
    }

    //----------------------------------  Handle signals
    mTerm.add(SIGTERM);
    mTerm.add(SIGHUP);
    mTerm.add(SIGINT);

    // mAttn.setMode(SigFlag::kBlock);
    mAttn.add(SIGUSR1);
    mAttn.add(SIGIO);

    mActive = true;
}

//======================================  Server destructor
DMTServer::~DMTServer(void) {
}

//======================================  Loop over messages and processing
int 
DMTServer::MainLoop(void) {
    while (mActive && !mTerm) {
	Time now = Now();
	if (mAttn) {
	    if (Debug() > 1)  cout << "Handle attention" << endl;
	    Attention();
	    mAttn.clear();
	    continue;
	} else if (now >= mWakeup) {
	    if (Debug() > 1)  cout << "Do processing" << endl;
	    ProcessData(now);
	    if (mWakeup <= now) mWakeup = now + mReschedule;
	    continue;
	}
	if (Debug() > 1)  cout << "Sleep til: " << mWakeup << endl;
	sleep_til(mWakeup);
    }
    return 0;
}

//======================================  kill the process
void
DMTServer::finish(void) {
    mActive = false;
}

//======================================  test if server argument
bool
DMTServer::isServerArg(const string& arg) const {
    if (arg == "-debug") return true;
    if (arg == "-dt")    return true;
    if (arg == "-name")  return true;
    return false;
}

//======================================  Set the scheduling interval
void 
DMTServer::setReschedule(Interval dt) {
    mReschedule = dt;
}

//======================================  Set the time to wake up
void 
DMTServer::setWakeup(const Time& t) {
    mWakeup = t;
}

//======================================  Set the time to wake up
void 
DMTServer::sleep_til(const Time& t) {
    Interval dt = t - Now();
    int nTic = int(dt);
    if (double(nTic) < double(dt)) nTic++;
    sleep(nTic);
}

//======================================  Handle an attention interrupt
void 
DMTServer::Attention(void) {
    MonServer::Attention();
}
