/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c2x -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) void
test135 (unsigned _BitInt(135) *p, unsigned _BitInt(135) *q,
	 int n1, int n2, int n3, int n4)
{
  p[0] = q[0] << n1;
  p[1] = q[1] >> n1;
  p[2] = ((_BitInt(135)) q[2]) >> n1;
  p[3] = ((_BitInt(135)) q[3]) >> n1;
  p[4] = q[0] << n2;
  p[5] = q[1] >> n2;
  p[6] = ((_BitInt(135)) q[2]) >> n2;
  p[7] = ((_BitInt(135)) q[3]) >> n2;
  p[8] = q[0] << n3;
  p[9] = q[1] >> n3;
  p[10] = ((_BitInt(135)) q[2]) >> n3;
  p[11] = ((_BitInt(135)) q[3]) >> n3;
  p[12] = q[0] << n4;
  p[13] = q[1] >> n4;
  p[14] = ((_BitInt(135)) q[2]) >> n4;
  p[15] = ((_BitInt(135)) q[3]) >> n4;
  p[16] = q[0] << 42;
  p[17] = q[1] >> 42;
  p[18] = ((_BitInt(135)) q[2]) >> 42;
  p[19] = ((_BitInt(135)) q[3]) >> 42;
  p[20] = q[0] << 64;
  p[21] = q[1] >> 64;
  p[22] = ((_BitInt(135)) q[2]) >> 64;
  p[23] = ((_BitInt(135)) q[3]) >> 64;
  p[24] = q[0] << 128;
  p[25] = q[1] >> 128;
  p[26] = ((_BitInt(135)) q[2]) >> 128;
  p[27] = ((_BitInt(135)) q[3]) >> 128;
  p[28] = q[0] << 134;
  p[29] = q[1] >> 134;
  p[30] = ((_BitInt(135)) q[2]) >> 134;
  p[31] = ((_BitInt(135)) q[3]) >> 134;
  p[32] = 42476074745096429931122498134186165182882uwb << n1;
  p[33] = ((unsigned _BitInt(135)) 7182038401320930422841151460488443466941uwb) >> n1;
  p[34] = ((_BitInt(135)) 19085908020200472220560502294394961233399uwb) >> n1;
  p[35] = ((_BitInt(135)) 22116103719729384017971523177401136866663uwb) >> n1;
  p[36] = 42476074745096429931122498134186165182882uwb << n2;
  p[37] = ((unsigned _BitInt(135)) 7182038401320930422841151460488443466941uwb) >> n2;
  p[38] = ((_BitInt(135)) 19085908020200472220560502294394961233399uwb) >> n2;
  p[39] = ((_BitInt(135)) 22116103719729384017971523177401136866663uwb) >> n2;
  p[40] = 42476074745096429931122498134186165182882uwb << n3;
  p[41] = ((unsigned _BitInt(135)) 7182038401320930422841151460488443466941uwb) >> n3;
  p[42] = ((_BitInt(135)) 19085908020200472220560502294394961233399uwb) >> n3;
  p[43] = ((_BitInt(135)) 22116103719729384017971523177401136866663uwb) >> n3;
  p[44] = 42476074745096429931122498134186165182882uwb << n4;
  p[45] = ((unsigned _BitInt(135)) 7182038401320930422841151460488443466941uwb) >> n4;
  p[46] = ((_BitInt(135)) 19085908020200472220560502294394961233399uwb) >> n4;
  p[47] = ((_BitInt(135)) 22116103719729384017971523177401136866663uwb) >> n4;
}

__attribute__((noipa)) void
check135 (void)
{
  static unsigned _BitInt(135) q[] = {
    42476074745096429931122498134186165182882uwb,
    7182038401320930422841151460488443466941uwb,
    19085908020200472220560502294394961233399uwb,
    22116103719729384017971523177401136866663uwb
  };
  static unsigned _BitInt(135) e[] = {
    42476074745096429931122498134186165182882uwb,
    7182038401320930422841151460488443466941uwb,
    19085908020200472220560502294394961233399uwb,
    22116103719729384017971523177401136866663uwb,
    20575191318237441766935416597984462241792uwb,
    1633006468482774476533711881uwb,
    4339633055724441924339885712uwb,
    43556142965875248422786905315316132038280uwb,
    37177976900770126499921313117382843039744uwb,
    389339081879323596127uwb,
    1034649146967993241391uwb,
    43556142965880123322149682894823775650690uwb,
    0uwb,
    0uwb,
    0uwb,
    43556142965880123323311949751266331066367uwb,
    20575191318237441766935416597984462241792uwb,
    1633006468482774476533711881uwb,
    4339633055724441924339885712uwb,
    43556142965875248422786905315316132038280uwb,
    37177976900770126499921313117382843039744uwb,
    389339081879323596127uwb,
    1034649146967993241391uwb,
    43556142965880123322149682894823775650690uwb,
    11569600475311907757754736652680119189504uwb,
    21uwb,
    56uwb,
    43556142965880123323311949751266331066304uwb,
    0uwb,
    0uwb,
    0uwb,
    43556142965880123323311949751266331066367uwb,
    42476074745096429931122498134186165182882uwb,
    7182038401320930422841151460488443466941uwb,
    19085908020200472220560502294394961233399uwb,
    22116103719729384017971523177401136866663uwb,
    20575191318237441766935416597984462241792uwb,
    1633006468482774476533711881uwb,
    4339633055724441924339885712uwb,
    43556142965875248422786905315316132038280uwb,
    37177976900770126499921313117382843039744uwb,
    389339081879323596127uwb,
    1034649146967993241391uwb,
    43556142965880123322149682894823775650690uwb,
    0uwb,
    0uwb,
    0uwb,
    43556142965880123323311949751266331066367uwb
  };
  unsigned _BitInt(135) p[48];
  test135 (p, q, 0, 42, 64, 134);
  for (int i = 0; i < 48; ++i)
    if (p[i] != e[i])
      __builtin_abort ();
}
#endif

#if __BITINT_MAXWIDTH__ >= 512
__attribute__((noipa)) void
test512 (unsigned _BitInt(512) *p, unsigned _BitInt(512) *q,
	 int n1, int n2, int n3, int n4)
{
  p[0] = q[0] << n1;
  p[1] = q[1] >> n1;
  p[2] = ((_BitInt(512)) q[2]) >> n1;
  p[3] = ((_BitInt(512)) q[3]) >> n1;
  p[4] = q[0] << n2;
  p[5] = q[1] >> n2;
  p[6] = ((_BitInt(512)) q[2]) >> n2;
  p[7] = ((_BitInt(512)) q[3]) >> n2;
  p[8] = q[0] << n3;
  p[9] = q[1] >> n3;
  p[10] = ((_BitInt(512)) q[2]) >> n3;
  p[11] = ((_BitInt(512)) q[3]) >> n3;
  p[12] = q[0] << n4;
  p[13] = q[1] >> n4;
  p[14] = ((_BitInt(512)) q[2]) >> n4;
  p[15] = ((_BitInt(512)) q[3]) >> n4;
  p[16] = q[0] << 42;
  p[17] = q[1] >> 42;
  p[18] = ((_BitInt(512)) q[2]) >> 42;
  p[19] = ((_BitInt(512)) q[3]) >> 42;
  p[20] = q[0] << 128;
  p[21] = q[1] >> 128;
  p[22] = ((_BitInt(512)) q[2]) >> 128;
  p[23] = ((_BitInt(512)) q[3]) >> 128;
  p[24] = q[0] << 448;
  p[25] = q[1] >> 448;
  p[26] = ((_BitInt(512)) q[2]) >> 448;
  p[27] = ((_BitInt(512)) q[3]) >> 448;
  p[28] = q[0] << 508;
  p[29] = q[1] >> 508;
  p[30] = ((_BitInt(512)) q[2]) >> 508;
  p[31] = ((_BitInt(512)) q[3]) >> 508;
  p[32] = 9097527363082920087640486649000739646642554439676331761072078127377091353030522027251795224024156478638697322090297961146123620822988442336252791731131761uwb << n1;
  p[33] = ((unsigned _BitInt(512)) 10980538984510266134209038127076610665614456653719209946870695541404134523537659134772423950250404838052362402691773947760040210438889408262830474547160577uwb) >> n1;
  p[34] = ((_BitInt(512)) 12876743501477007697566238617479065502697488744690997490715841276784967745445096442239218949897451583348811842533777310497473584791607823667593623282470690uwb) >> n1;
  p[35] = ((_BitInt(512)) 4262081036274094578799387151850586986318909215082769698752506214098468276589787535239660955472257640044493313997722061552113957148668088011463028119497203uwb) >> n1;
  p[36] = 9097527363082920087640486649000739646642554439676331761072078127377091353030522027251795224024156478638697322090297961146123620822988442336252791731131761uwb << n2;
  p[37] = ((unsigned _BitInt(512)) 10980538984510266134209038127076610665614456653719209946870695541404134523537659134772423950250404838052362402691773947760040210438889408262830474547160577uwb) >> n2;
  p[38] = ((_BitInt(512)) 12876743501477007697566238617479065502697488744690997490715841276784967745445096442239218949897451583348811842533777310497473584791607823667593623282470690uwb) >> n2;
  p[39] = ((_BitInt(512)) 4262081036274094578799387151850586986318909215082769698752506214098468276589787535239660955472257640044493313997722061552113957148668088011463028119497203uwb) >> n2;
  p[40] = 9097527363082920087640486649000739646642554439676331761072078127377091353030522027251795224024156478638697322090297961146123620822988442336252791731131761uwb << n3;
  p[41] = ((unsigned _BitInt(512)) 10980538984510266134209038127076610665614456653719209946870695541404134523537659134772423950250404838052362402691773947760040210438889408262830474547160577uwb) >> n3;
  p[42] = ((_BitInt(512)) 12876743501477007697566238617479065502697488744690997490715841276784967745445096442239218949897451583348811842533777310497473584791607823667593623282470690uwb) >> n3;
  p[43] = ((_BitInt(512)) 4262081036274094578799387151850586986318909215082769698752506214098468276589787535239660955472257640044493313997722061552113957148668088011463028119497203uwb) >> n3;
  p[44] = 9097527363082920087640486649000739646642554439676331761072078127377091353030522027251795224024156478638697322090297961146123620822988442336252791731131761uwb << n4;
  p[45] = ((unsigned _BitInt(512)) 10980538984510266134209038127076610665614456653719209946870695541404134523537659134772423950250404838052362402691773947760040210438889408262830474547160577uwb) >> n4;
  p[46] = ((_BitInt(512)) 12876743501477007697566238617479065502697488744690997490715841276784967745445096442239218949897451583348811842533777310497473584791607823667593623282470690uwb) >> n4;
  p[47] = ((_BitInt(512)) 4262081036274094578799387151850586986318909215082769698752506214098468276589787535239660955472257640044493313997722061552113957148668088011463028119497203uwb) >> n4;
}

__attribute__((noipa)) void
check512 (void)
{
  static unsigned _BitInt(512) q[] = {
    9097527363082920087640486649000739646642554439676331761072078127377091353030522027251795224024156478638697322090297961146123620822988442336252791731131761uwb,
    10980538984510266134209038127076610665614456653719209946870695541404134523537659134772423950250404838052362402691773947760040210438889408262830474547160577uwb,
    12876743501477007697566238617479065502697488744690997490715841276784967745445096442239218949897451583348811842533777310497473584791607823667593623282470690uwb,
    4262081036274094578799387151850586986318909215082769698752506214098468276589787535239660955472257640044493313997722061552113957148668088011463028119497203uwb
  };
  static unsigned _BitInt(512) e[] = {
    9097527363082920087640486649000739646642554439676331761072078127377091353030522027251795224024156478638697322090297961146123620822988442336252791731131761uwb,
    10980538984510266134209038127076610665614456653719209946870695541404134523537659134772423950250404838052362402691773947760040210438889408262830474547160577uwb,
    12876743501477007697566238617479065502697488744690997490715841276784967745445096442239218949897451583348811842533777310497473584791607823667593623282470690uwb,
    4262081036274094578799387151850586986318909215082769698752506214098468276589787535239660955472257640044493313997722061552113957148668088011463028119497203uwb,
    10218316460994285180012649605314270523237657334799736878274366250937214257494608460860805097020820895335285270507764849854590883398363325859206256763338752uwb,
    2496685507255794194454446853132278798878918827021882395199712741806282457113788753934482872466652415380931962020389152658035575413780272415995uwb,
    13407807929942476349503027617752125851028760573258773505654590291089987162470240268148950606329516537581906483867747705640627526941493352884606809182595733uwb,
    969085030254540147052327290987383773044464127243093048207926179679468140554897112278845487588172918559506186738354258875941458688582335528613uwb,
    4525270648672298630142654159362692277322833548500556080109956060745476990024701673931929946646742265188085348185747949082408104800714710883682097140072448uwb,
    32268903863189288488713934263516911045475287395472229484457927100461194379105000512730600516708300749874729300692099uwb,
    13407807929942597099574024998205846127477805162503433459831226837705045157447168014945448530707208458194409230122434920121875298152320690554956588365115043uwb,
    12525130452217498057057362011967217536814658172404918356180491125021477447649640662315333513294816018260736989782778uwb,
    837987995621412318723376562387865382967460363787024586107722590232610251879596686050117143635431464230626991136655378178359617675746660621652103062880256uwb,
    13uwb,
    13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084095uwb,
    5uwb,
    10218316460994285180012649605314270523237657334799736878274366250937214257494608460860805097020820895335285270507764849854590883398363325859206256763338752uwb,
    2496685507255794194454446853132278798878918827021882395199712741806282457113788753934482872466652415380931962020389152658035575413780272415995uwb,
    13407807929942476349503027617752125851028760573258773505654590291089987162470240268148950606329516537581906483867747705640627526941493352884606809182595733uwb,
    969085030254540147052327290987383773044464127243093048207926179679468140554897112278845487588172918559506186738354258875941458688582335528613uwb,
    4525270648672298630142654159362692277322833548500556080109956060745476990024701673931929946646742265188085348185747949082408104800714710883682097140072448uwb,
    32268903863189288488713934263516911045475287395472229484457927100461194379105000512730600516708300749874729300692099uwb,
    13407807929942597099574024998205846127477805162503433459831226837705045157447168014945448530707208458194409230122434920121875298152320690554956588365115043uwb,
    12525130452217498057057362011967217536814658172404918356180491125021477447649640662315333513294816018260736989782778uwb,
    2707788752018291762501261467556359376968672839961555769866726160891698235759394800413405351174494371110296852192103378240576483613979086982233831308787712uwb,
    15107256420812902421uwb,
    13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569215784041721807999uwb,
    5863860707758186186uwb,
    837987995621412318723376562387865382967460363787024586107722590232610251879596686050117143635431464230626991136655378178359617675746660621652103062880256uwb,
    13uwb,
    13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084095uwb,
    5uwb,
    9097527363082920087640486649000739646642554439676331761072078127377091353030522027251795224024156478638697322090297961146123620822988442336252791731131761uwb,
    10980538984510266134209038127076610665614456653719209946870695541404134523537659134772423950250404838052362402691773947760040210438889408262830474547160577uwb,
    12876743501477007697566238617479065502697488744690997490715841276784967745445096442239218949897451583348811842533777310497473584791607823667593623282470690uwb,
    4262081036274094578799387151850586986318909215082769698752506214098468276589787535239660955472257640044493313997722061552113957148668088011463028119497203uwb,
    10218316460994285180012649605314270523237657334799736878274366250937214257494608460860805097020820895335285270507764849854590883398363325859206256763338752uwb,
    2496685507255794194454446853132278798878918827021882395199712741806282457113788753934482872466652415380931962020389152658035575413780272415995uwb,
    13407807929942476349503027617752125851028760573258773505654590291089987162470240268148950606329516537581906483867747705640627526941493352884606809182595733uwb,
    969085030254540147052327290987383773044464127243093048207926179679468140554897112278845487588172918559506186738354258875941458688582335528613uwb,
    4525270648672298630142654159362692277322833548500556080109956060745476990024701673931929946646742265188085348185747949082408104800714710883682097140072448uwb,
    32268903863189288488713934263516911045475287395472229484457927100461194379105000512730600516708300749874729300692099uwb,
    13407807929942597099574024998205846127477805162503433459831226837705045157447168014945448530707208458194409230122434920121875298152320690554956588365115043uwb,
    12525130452217498057057362011967217536814658172404918356180491125021477447649640662315333513294816018260736989782778uwb,
    837987995621412318723376562387865382967460363787024586107722590232610251879596686050117143635431464230626991136655378178359617675746660621652103062880256uwb,
    13uwb,
    13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084095uwb,
    5uwb
  };
  unsigned _BitInt(512) p[48];
  test512 (p, q, 0, 42, 128, 508);
  for (int i = 0; i < 48; ++i)
    if (p[i] != e[i])
      __builtin_abort ();
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) void
test575 (unsigned _BitInt(575) *p, unsigned _BitInt(575) *q,
	 int n1, int n2, int n3, int n4)
{
  p[0] = q[0] << n1;
  p[1] = q[1] >> n1;
  p[2] = ((_BitInt(575)) q[2]) >> n1;
  p[3] = ((_BitInt(575)) q[3]) >> n1;
  p[4] = q[0] << n2;
  p[5] = q[1] >> n2;
  p[6] = ((_BitInt(575)) q[2]) >> n2;
  p[7] = ((_BitInt(575)) q[3]) >> n2;
  p[8] = q[0] << n3;
  p[9] = q[1] >> n3;
  p[10] = ((_BitInt(575)) q[2]) >> n3;
  p[11] = ((_BitInt(575)) q[3]) >> n3;
  p[12] = q[0] << n4;
  p[13] = q[1] >> n4;
  p[14] = ((_BitInt(575)) q[2]) >> n4;
  p[15] = ((_BitInt(575)) q[3]) >> n4;
  p[16] = q[0] << 42;
  p[17] = q[1] >> 42;
  p[18] = ((_BitInt(575)) q[2]) >> 42;
  p[19] = ((_BitInt(575)) q[3]) >> 42;
  p[20] = q[0] << 192;
  p[21] = q[1] >> 192;
  p[22] = ((_BitInt(575)) q[2]) >> 192;
  p[23] = ((_BitInt(575)) q[3]) >> 192;
  p[24] = q[0] << 512;
  p[25] = q[1] >> 512;
  p[26] = ((_BitInt(575)) q[2]) >> 512;
  p[27] = ((_BitInt(575)) q[3]) >> 512;
  p[28] = q[0] << 571;
  p[29] = q[1] >> 571;
  p[30] = ((_BitInt(575)) q[2]) >> 571;
  p[31] = ((_BitInt(575)) q[3]) >> 571;
  p[32] = 113324867609914841703175642134276622099380829892372739396576941405077427208321982380320777205398087845718962965838410365091485839739660235868692128339145588495862488649829794uwb << n1;
  p[33] = ((unsigned _BitInt(575)) 41459088230466967850496491762687877054451372305979858752985908904079765739347588525764439571939913205917422711129986893243036538436025937944895336127976720299879937518567087uwb) >> n1;
  p[34] = ((_BitInt(575)) 109919844636328732719844961828946648695154594766841929826820254974351382414676962372262457317295280532708618631627677422093887137875656283935370428037454681114775307971502401uwb) >> n1;
  p[35] = ((_BitInt(575)) 146719349625858150924070326030117352429884uwb) >> n1;
  p[36] = 113324867609914841703175642134276622099380829892372739396576941405077427208321982380320777205398087845718962965838410365091485839739660235868692128339145588495862488649829794uwb << n2;
  p[37] = ((unsigned _BitInt(575)) 41459088230466967850496491762687877054451372305979858752985908904079765739347588525764439571939913205917422711129986893243036538436025937944895336127976720299879937518567087uwb) >> n2;
  p[38] = ((_BitInt(575)) 109919844636328732719844961828946648695154594766841929826820254974351382414676962372262457317295280532708618631627677422093887137875656283935370428037454681114775307971502401uwb) >> n2;
  p[39] = ((_BitInt(575)) 146719349625858150924070326030117352429884uwb) >> n2;
  p[40] = 113324867609914841703175642134276622099380829892372739396576941405077427208321982380320777205398087845718962965838410365091485839739660235868692128339145588495862488649829794uwb << n3;
  p[41] = ((unsigned _BitInt(575)) 41459088230466967850496491762687877054451372305979858752985908904079765739347588525764439571939913205917422711129986893243036538436025937944895336127976720299879937518567087uwb) >> n3;
  p[42] = ((_BitInt(575)) 109919844636328732719844961828946648695154594766841929826820254974351382414676962372262457317295280532708618631627677422093887137875656283935370428037454681114775307971502401uwb) >> n3;
  p[43] = ((_BitInt(575)) 146719349625858150924070326030117352429884uwb) >> n3;
  p[44] = 113324867609914841703175642134276622099380829892372739396576941405077427208321982380320777205398087845718962965838410365091485839739660235868692128339145588495862488649829794uwb << n4;
  p[45] = ((unsigned _BitInt(575)) 41459088230466967850496491762687877054451372305979858752985908904079765739347588525764439571939913205917422711129986893243036538436025937944895336127976720299879937518567087uwb) >> n4;
  p[46] = ((_BitInt(575)) 109919844636328732719844961828946648695154594766841929826820254974351382414676962372262457317295280532708618631627677422093887137875656283935370428037454681114775307971502401uwb) >> n4;
  p[47] = ((_BitInt(575)) 146719349625858150924070326030117352429884uwb) >> n4;
}

__attribute__((noipa)) void
check575 (void)
{
  static unsigned _BitInt(575) q[] = {
    113324867609914841703175642134276622099380829892372739396576941405077427208321982380320777205398087845718962965838410365091485839739660235868692128339145588495862488649829794uwb,
    41459088230466967850496491762687877054451372305979858752985908904079765739347588525764439571939913205917422711129986893243036538436025937944895336127976720299879937518567087uwb,
    109919844636328732719844961828946648695154594766841929826820254974351382414676962372262457317295280532708618631627677422093887137875656283935370428037454681114775307971502401uwb,
    146719349625858150924070326030117352429884uwb
  };
  static unsigned _BitInt(575) e[] = {
    113324867609914841703175642134276622099380829892372739396576941405077427208321982380320777205398087845718962965838410365091485839739660235868692128339145588495862488649829794uwb,
    41459088230466967850496491762687877054451372305979858752985908904079765739347588525764439571939913205917422711129986893243036538436025937944895336127976720299879937518567087uwb,
    109919844636328732719844961828946648695154594766841929826820254974351382414676962372262457317295280532708618631627677422093887137875656283935370428037454681114775307971502401uwb,
    146719349625858150924070326030117352429884uwb,
    101455192616810418556035937342706675871010989953664553100414183440061081538258837413103429652228409332846843840874129218733451063018756151973814520650589185972971648957022208uwb,
    9426705271486518506775721962796496212479581187376392961820308506521488593386399890224411040421708368266404866319586947893875853523246846167443285623443607687449uwb,
    123665200736549141698114476634013378335753822194910362276561280288452288465223455053720457123832123393578819366656336301874379580455931868022178318582504526998711692029382704uwb,
    33360117783071962304363825303uwb,
    119335782055317388350429004017843053262176261916736710874511715722133065797591485333905865472877802228449910525321848531626543800663717410928997924003288981168896718112030720uwb,
    6604813810288358087498962398528278947817002383742106838987637054195488521780512729133747937326520831885279330684711uwb,
    123665200736552267030251260509823595017565674550605919957029338284886722431114354919535001603397736344270114443080692270543186446588141616503700255078449149331258830163424370uwb,
    0uwb,
    15458150092069033378781407563727949377195709318825739994628941005806076569158241698144775066327690311849854464126008708709460314644171950622971634693868322994787923259293696uwb,
    5uwb,
    123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349566uwb,
    0uwb,
    101455192616810418556035937342706675871010989953664553100414183440061081538258837413103429652228409332846843840874129218733451063018756151973814520650589185972971648957022208uwb,
    9426705271486518506775721962796496212479581187376392961820308506521488593386399890224411040421708368266404866319586947893875853523246846167443285623443607687449uwb,
    123665200736549141698114476634013378335753822194910362276561280288452288465223455053720457123832123393578819366656336301874379580455931868022178318582504526998711692029382704uwb,
    33360117783071962304363825303uwb,
    119335782055317388350429004017843053262176261916736710874511715722133065797591485333905865472877802228449910525321848531626543800663717410928997924003288981168896718112030720uwb,
    6604813810288358087498962398528278947817002383742106838987637054195488521780512729133747937326520831885279330684711uwb,
    123665200736552267030251260509823595017565674550605919957029338284886722431114354919535001603397736344270114443080692270543186446588141616503700255078449149331258830163424370uwb,
    0uwb,
    71526316958236649113771106427618495658375006450241431334816139660708009688265701502532725246129480508017794237793207540593595178136921012216679830157648896249487052159057920uwb,
    3092160064277148905uwb,
    123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946582933127893402865396uwb,
    0uwb,
    15458150092069033378781407563727949377195709318825739994628941005806076569158241698144775066327690311849854464126008708709460314644171950622971634693868322994787923259293696uwb,
    5uwb,
    123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349566uwb,
    0uwb,
    113324867609914841703175642134276622099380829892372739396576941405077427208321982380320777205398087845718962965838410365091485839739660235868692128339145588495862488649829794uwb,
    41459088230466967850496491762687877054451372305979858752985908904079765739347588525764439571939913205917422711129986893243036538436025937944895336127976720299879937518567087uwb,
    109919844636328732719844961828946648695154594766841929826820254974351382414676962372262457317295280532708618631627677422093887137875656283935370428037454681114775307971502401uwb,
    146719349625858150924070326030117352429884uwb,
    101455192616810418556035937342706675871010989953664553100414183440061081538258837413103429652228409332846843840874129218733451063018756151973814520650589185972971648957022208uwb,
    9426705271486518506775721962796496212479581187376392961820308506521488593386399890224411040421708368266404866319586947893875853523246846167443285623443607687449uwb,
    123665200736549141698114476634013378335753822194910362276561280288452288465223455053720457123832123393578819366656336301874379580455931868022178318582504526998711692029382704uwb,
    33360117783071962304363825303uwb,
    119335782055317388350429004017843053262176261916736710874511715722133065797591485333905865472877802228449910525321848531626543800663717410928997924003288981168896718112030720uwb,
    6604813810288358087498962398528278947817002383742106838987637054195488521780512729133747937326520831885279330684711uwb,
    123665200736552267030251260509823595017565674550605919957029338284886722431114354919535001603397736344270114443080692270543186446588141616503700255078449149331258830163424370uwb,
    0uwb,
    15458150092069033378781407563727949377195709318825739994628941005806076569158241698144775066327690311849854464126008708709460314644171950622971634693868322994787923259293696uwb,
    5uwb,
    123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349566uwb,
    0uwb
  };
  unsigned _BitInt(575) p[48];
  test575 (p, q, 0, 42, 192, 571);
  for (int i = 0; i < 48; ++i)
    if (p[i] != e[i])
      __builtin_abort ();
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 135
  check135 ();
#endif
#if __BITINT_MAXWIDTH__ >= 512
  check512 ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  check575 ();
#endif
  return 0;
}
