/* PR c/102989 */
/* { dg-do run { target { bitint && int32plus } } } */
/* { dg-options "-std=c2x -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) void
test_135 (unsigned _BitInt(135) *p, unsigned _BitInt(39) *q, int i)
{
  p[3] = p[0] / p[1];
  p[4] = p[2] / *q;
  p[5] = p[i] % p[1 + i];
  p[6] = p[2 + i] % q[i];
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) void
test_192 (unsigned _BitInt(192) *p, unsigned _BitInt(62) *q, int i)
{
  p[3] = p[0] / p[1];
  p[4] = p[2] / *q;
  p[5] = p[i] % p[1 + i];
  p[6] = p[2 + i] % q[i];
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) void
test_575 (unsigned _BitInt(575) *p, unsigned _BitInt(125) *q, int i)
{
  p[3] = p[0] / p[1];
  p[4] = p[2] / *q;
  p[5] = p[i] % p[1 + i];
  p[6] = p[2 + i] % q[i];
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 135
  static unsigned _BitInt(135) s135[] = {
    39967592296255191197035336461290090324829uwb,
    312558523056789678960549094065358uwb,
    32832062726968675550596542626872563693099uwb,
    0, 0, 0, 0,
    39684305085076546670125468925068uwb,
    6804617795530664696186192571276807994017uwb,
    908900452537968951389639987294090uwb,
    0, 0, 0, 0,
    20395215776806618633686937572550377003558uwb,
    1uwb,
    2017874535031304931048003948865783841241uwb,
    0, 0, 0, 0,
    16804502949303659647220377886348649uwb,
    15969624846496231063802991739581uwb,
    12583271616670577644431817717623569600333uwb,
    0, 0, 0, 0,
    127872348uwb,
    89851078235647451008683745245uwb,
    65571357606183724433879897404245uwb,
    87071527329uwb,
    0uwb,
    2093478262068616207802533uwb,
    39684305085076546670125468925068uwb,
    228138242uwb,
    20395215776806618633686937572550377003558uwb,
    12999486295301452164134194354389uwb,
    0uwb,
    65232213uwb,
    1052uwb,
    299601705158823277248376612324370704769uwb,
    4457610789624568099630576309437uwb,
    35uwb
  };
  static unsigned _BitInt(39) s39[] = {
    365405328146uwb,
    434158056uwb,
    155227252uwb,
    42uwb
  };
  for (int i = 0; i < 4; ++i)
    {
      test_135 (s135 + 7 * i, s39 + i, 0);
      for (int j = 0; j < 4; ++j)
	if (s135[7 * i + 3 + j] != s135[7 * 4 + 4 * i + j])
	  __builtin_abort ();
    }
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static unsigned _BitInt(192) s192[] = {
    1124505164324393257294640774883626666393496137407657383285uwb,
    267770052679215918410877624132556357420375522461819642uwb,
    4639722531344459905931256257525470190970246632351027146771uwb,
    0, 0, 0, 0,
    37076404019741709360338653279977uwb,
    4017103983634913740425503780735862298200532685100197316953uwb,
    3278541912894246916134094695331450716143029898422059693966uwb,
    0, 0, 0, 0,
    181260360652955273548771772757571198044332327135683350561uwb,
    3uwb,
    278424729322219534657080470631020618602047522343uwb,
    0, 0, 0, 0,
    1546922522984382736106987324181069322701408057466881095437uwb,
    2859498891267655913293729558067200232488079281528uwb,
    3754903553201168811081807274774774084224112858563658575772uwb,
    0, 0, 0, 0,
    4199uwb,
    1361868478710180046608174894774272890845uwb,
    138713124365615887365631151022521585339318590476706527uwb,
    704022636372799201uwb,
    0uwb,
    1800071738275562493471915107371110587374384505uwb,
    37076404019741709360338653279977uwb,
    989224815596uwb,
    60420120217651757849590590919190399348110775711894450187uwb,
    35811149155369659378220712438655uwb,
    0uwb,
    971271817233568uwb,
    540976787uwb,
    268207396657226343648700519626769577444579489897404183983uwb,
    356343883111794920610945410844353911944595204901uwb,
    10uwb
  };
  static unsigned _BitInt(62) s62[] = {
    3406880035683564506uwb,
    1821339585074uwb,
    7774805776666105uwb,
    14uwb
  };
  for (int i = 0; i < 4; ++i)
    {
      test_192 (s192 + 7 * i, s62 + i, 0);
      for (int j = 0; j < 4; ++j)
	if (s192[7 * i + 3 + j] != s192[7 * 4 + 4 * i + j])
	  __builtin_abort ();
    }
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static unsigned _BitInt(575) s575[] = {
    68262105478469356136430990337792292171975154797241096882998520215082649730969604949380226799284423285674920339289406073226899446201591827481846481242318203838114185414101609uwb,
    522191246473430521641066810210970739255168853016819760532584735359478867620239849176927824047731938802486584777452655079470889576128018146184619338332252916338uwb,
    3435470059299599312416077239534464560179043115309368866437635382063534713476732558299272800804091725646363342046360614869573337710790812486381755554721429381220646362uwb,
    0, 0, 0, 0,
    1395593888697848626057320338038084790564831152710988743807319327067660279846004696629681887779842129545558985841571482256386uwb,
    21441995702257150447349407715894435455050772126685461031315827571889336447926694701361700730379084806621691641000793333457504299685338550064151630805530260276144722300318378uwb,
    1810496946211232933828329287232831944898449501818263455079805575961543103376888822223202088001971904867510317357383306521333499198279246848350610021364570531uwb,
    0, 0, 0, 0,
    49645180073615279861687094823459626955281549193691328477580826482861925123118554141451230055925103484376691314925103229496483975307219087542024089047037648064847114147876643uwb,
    5uwb,
    107934287940096962208124285810972463665238866518161589834947495273979231095066254158254278656128778606292981405785821524489035396101282777095285918056890626313652996363360635uwb,
    0, 0, 0, 0,
    23608107814490548232484082204335368855445148092939475311496653239338164906367806895605948777993633707136572413097677855946274968766053297446456942019070196462866449343995194uwb,
    2583203116898176965174690967993977971553570592649244007260134674599130988578292547989776393639164uwb,
    275574884364090029934989506452294812428150053792728044335881034126425125444715551780251783116966457185581504439797097624639857491748084495990405201247685674533629814uwb,
    0, 0, 0, 0,
    130722423900191uwb,
    98209305532955450849963417931387543706587302562952677389372338515039360888927455577958981902466648551427758908831114835123178381uwb,
    452871192905895539483003814306315901853065835276102489810630370966701886335873219401733574293829636677996055324174200714778800368052970790656772945453428881051uwb,
    22873946842052620485494389199978222125uwb,
    0uwb,
    47552124733256427939572722329767524480111793387357122806941820665877774450470824535764237662603507442099431904312121406656289uwb,
    1395593888697848626057320338038084790564831152710988743807319327067660279846004696629681887779842129545558985841571482256386uwb,
    12402931424678892069400953011343uwb,
    9929036014723055972337418964691925391056309838738265695516165296572385024623710828290246011185020696875338262985020645899296795061443817508404817809407529612969422829575328uwb,
    765676291859168654790768770138076157159515580930329832291016877204190990758886004368955392441159337179098419446671535422387547862111454482076132380462913464uwb,
    3uwb,
    139483670059084867uwb,
    9139083047731208433628027573752517850138452745189939065766817977544782897707uwb,
    582502183871265798930967135317783829723227597448966288820692884195884049998974821351103238544771373433464199926206342695349404216240804690670860uwb,
    331751853749540937734694164624358910388009028150635800666238028944699092436048473910402462998246uwb,
    30656037717616877434uwb
  };
  static unsigned _BitInt(125) s125[] = {
    34981105310298535974120492274604066977uwb,
    38073944253116192522082228985492uwb,
    140965952697865937uwb,
    473088156567311094933uwb
  };
  for (int i = 0; i < 4; ++i)
    {
      test_575 (s575 + 7 * i, s125 + i, 0);
      for (int j = 0; j < 4; ++j)
	if (s575[7 * i + 3 + j] != s575[7 * 4 + 4 * i + j])
	  __builtin_abort ();
    }
#endif
}
