/* PR c/102989 */
/* { dg-do run { target { bitint && int32plus } } } */
/* { dg-options "-std=gnu2x" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if defined(__SIZEOF_INT128__) && __SIZEOF_INT128__ * __CHAR_BIT__ == 128
#define int128_val(x, y) x
#define int128_bitfld(x) x
#define int128 __int128
#else
#define int128_val(x, y) y
#define int128_bitfld(x) 1
#define int128 int
#endif
#if __SIZEOF_SHORT__ * __CHAR_BIT__ == 16
#define shrt_val(x, y) x
#else
#define shrt_val(x, y) y
#endif
#if __SIZEOF_INT__ * __CHAR_BIT__ == 32
#define int_val(x, y) x
#else
#define int_val(x, y) y
#endif
#if __SIZEOF_LONG_LONG__ * __CHAR_BIT__ == 64
#define llong_val(x, y) x
#else
#define llong_val(x, y) y
#endif

struct S {
  int i : 1;
  int j : 27;
  long long k : 56;
  int128 l : int128_bitfld (120);
  unsigned m : 3;
  unsigned long long n : 42;
  unsigned int128 o : int128_bitfld (125);
};

#if __BITINT_MAXWIDTH__ >= 188
__attribute__((noipa)) void
test188 (int *a, long long *b, int128 *c, unsigned short *d,
	 unsigned long long *e, unsigned int128 *f, _BitInt(188) *g,
	 struct S *p)
{
  *a = g[0] + g[1];
  *b = (_BitInt(188)) ((unsigned _BitInt(188)) g[2] - g[3]);
  *c = g[4];
  *d = (_BitInt(188)) ((unsigned _BitInt(188)) g[5] << 3);
  *e = (unsigned _BitInt(188)) g[6];
  *f = -g[7];
  p->i = g[8] | 256wb;
  p->j = g[9] ^ 513wb;
  p->k = g[10] & g[11];
  p->l = g[12];
  p->m = (g[13] | g[14]) + g[15];
  p->n = g[16];
  p->o = g[17];
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) void
test575 (int *a, long long *b, int128 *c, unsigned short *d,
	 unsigned long long *e, unsigned int128 *f, _BitInt(575) *g,
	 struct S *p)
{
  *a = g[0] + g[1];
  *b = g[2] - g[3];
  *c = g[4];
  *d = g[5] << 3;
  *e = (unsigned _BitInt(575)) g[6];
  *f = -g[7];
  p->i = g[8] | 256wb;
  p->j = g[9] ^ 513wb;
  p->k = g[10] & g[11];
  p->l = g[12];
  p->m = (g[13] | g[14]) + g[15];
  p->n = g[16];
  p->o = g[17];
}
#endif

int
main ()
{
  struct S s;
  int a;
  long long b;
  int128 c;
  unsigned short d;
  unsigned long long e;
  unsigned int128 f;
  (void) &s;
#if __BITINT_MAXWIDTH__ >= 188
  _BitInt(188) g188[18] = {
    -159047363318536960484353065517373654721104396757490314295wb,
    -3121544831087579708485147608149039646353048280619431708wb,
    159318071862725567512368472768918962735450536041547197357wb,
    -40707507555068524326919847225737421498619613998666182429wb,
    165320903343659124097264390671505112912629878959843721491wb,
    -127515148002861399222757129930766493340235768486498578219wb,
    -105034079444454534611827588421185078564296081131064901461wb,
    92590184827335405203162269451222486819220604151446603018wb,
    -180312039117739394533672196677501644999924031772292123301wb,
    -144189136904129889279453036150725630022817508409138149279wb,
    -149481812493652088098408785514342084106630686193276241281wb,
    -167177289711809249257738519322903628222027157941774765457wb,
    -143084017548841355414802324960482130843700645074551425158wb,
    58479706299212198491939673148493577279739517540183806582wb,
    -56927106028567263826833143638316408260616106349933917222wb,
    -51398435670153923584906245550632035515359744807385001406wb,
    42134285326135692487901360354060672379510798359809381879wb,
    88023866651707391895300914626945857947221302817073781445wb
  };
  test188 (&a, &b, &c, &d, &e, &f, &g188[0], &s);
  if (a != int_val (0x07181cad, (int) 230149950312043007546898625824956456638939770240892411053uwb)
      || b != llong_val ((long long) 0xde59a69b154ddacaLL, (long long) 200025579417794091839288319994656384234070150040213379786uwb)
      || c != int128_val ((int128) 0xd1d8047ea714e976fb0ddacd903a4113uwb, int_val ((int) 0x903a4113, (int) 165320903343659124097264390671505112912629878959843721491uwb))
      || d != shrt_val (0x86a8, (unsigned short) 156835391362111449437153477405305506297305497945017845416uwb)
      || e != llong_val (0xf4603045301e40abULL, (unsigned long long) 287284779017213013127909250529294072442101134147937255595uwb)
      || f != int128_val ((unsigned int128) 0x36333fc0e67c1648df996844ae607af6uwb, int_val ((unsigned) 0xae607af6, (unsigned) 299728673634332142536574569499256664187176611127555554038uwb))
      || s.i != -1
      || s.j != 0x3150a60
      || s.k != 0x0501922b16326fLL
      || s.l != int128_val ((int128) 0xffa05b2a80ae9f589ff82df4ec30377auwb, 0)
      || s.m != 0
      || s.n != 0xbea55655f7ULL
      || s.o != int128_val ((unsigned int128) 0x11424021a09eb39f0078be56f505dac5uwb, 1))
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  _BitInt(575) g575[18] = {
    -47005092370981353509019585272930171576138837874594474940633343041444523868768398171568402914237822300343064860032430047905208253183368063860751727493912961793713775785286761wb,
    42995314282090421850185028248818616047989631648441809220202839707075135953582887789310579563290411495625582960818510026163313766713468119555853185204024156985186870447558448wb,
    -4310949275737056279952323703666519147345926215446595910688661460043187233007608392215115192894183359414559767132447689960645444722310313612870802800517291553651832872230377wb,
    -60174333254167907860375485189824486743221145295071697779574672977710903042875235567137515476943834663106195143844820080789913163377976708972634731997186324672887273760550843wb,
    514999616465082372590625134373624423612122508361343296847148750502235576952627411211915080142588943086581680871086375952582973053262315744074678352482468176498475765238014wb,
    -34524529098838981071360498102806028847960079898011114995185678340915753622610778619950150604678383174181175565220899355393832542080300168653321490778607415279583262404019715wb,
    57435829357765689198701253918538231677782825819649130906117703766412930883719480639328241453985120284446411689340430788174994800799501628170332549761733355178989958217690176wb,
    55372038211321583831991526729411129160052836002754320808356246247126956944240411995457998940239431679806969029801755058644044152079840612142503912508386823751242378280351248wb,
    16465587034692152401588675199252528652333806863385560487958043658459465122879621696065063317705307064863781999117926295249319492796685349901264833471330673488325230233633156wb,
    29447367895156340838084654771430520820905636269084897202980661633115991361986283452296000775941804019961160709602424696981982973428884144037654036591675815222144356989137377wb,
    -11405270033186719236304815495700559798454505639686440514251001395033465367140240658561115444561532342526965619895711017904459977515469290641005572154684851264335049868864497wb,
    108093905149568033165371492635656748567249268116953654298668927833251941040419562425217780888127352768755220577595921193600804563557700826867049089803222938826670338302530wb,
    -31360750000107936163671456129190056884574874172627927813113803212980739137815442376155550405060248732467083955605320651972161402853892464960579922753500965033770359737153351wb,
    -8682946747028473458400698043390376356896046446946536663094478822504353095327345833145506855874926356083877643554724567774187375944555393553847900623220497209797513931185240wb,
    -22144855016132297032977142230889176517935104503579623594553342478323802903759572545707546713930097548953805249628758279309623598839610808070152925878316419950140234764905470wb,
    -10411562563660012059020319572234253583259323305689321838048522585769451002745393609294442107707749261789472265492124615971403756074402546875951159988775650555291608910079211wb,
    -35303144058707185327630269206553728380732193353770095499658757423571059983534369285427585500543929872684039303017125049206013674506050937891922504600168970885730004765890909wb,
    -10288638308173362696633233706439807781761277611815792314525923347956953720054374840733498198399501888078817738532473821245337293721068994241744635656437058172223152460622488wb
  };
  test575 (&a, &b, &c, &d, &e, &f, &g575[0], &s);
  if (a != int_val (-0x2a104d39, (int) -4009778088890931658834557024111555528149206226152665720430503334369387915185510382257823350947410804717481899213920021741894486469899944304898542289888804808526905337728313wb)
      || b != llong_val ((long long) 0xf6c7e117bacd11d2LL, (long long) 55863383978430851580423161486157967595875219079625101868886011517667715809867627174922400284049651303691635376712372390829267718655666395359763929196669033119235440888320466uwb)
      || c != int128_val ((int128) 0x75504b73f68a3225400491eb337288feuwb, int_val ((int) 0x337288fe, (int) 514999616465082372590625134373624423612122508361343296847148750502235576952627411211915080142588943086581680871086375952582973053262315744074678352482468176498475765238014uwb))
      || d != shrt_val (0xcfe8, (unsigned short) 94799369418944952519869796707022554269016384467728839909609157412019808678911571795873396754437502090947102617257014165876387214817725465724747306423980429638244058990890984uwb)
      || e != llong_val (0xa6a61a4adeb96c40ULL, (unsigned long long) 57435829357765689198701253918538231677782825819649130906117703766412930883719480639328241453985120284446411689340430788174994800799501628170332549761733355178989958217690176uwb)
      || f != int128_val ((unsigned int128) 0xd2a8d84eae8410641083c38afaa549f0uwb, int_val ((unsigned) 0xfaa549f0, (unsigned) 68293162525230683198259733780412465857512838547851599148675281799321655609025521589700201590382090814991866683206314611031638365073534992841269165042559760207061007793998320uwb))
      || s.i != 0
      || s.j != -0x2920c20
      || s.k != -0x1bddffff3afffeLL
      || s.l != int128_val ((int128) 0xffb52493069ee4e254bf24bbba7a08b9uwb, -1)
      || s.m != 7
      || s.n != 0x1cbf11e26a3ULL
      || s.o != int128_val ((unsigned int128) 0x12a63362222ec8f7f2c7e52793b49568uwb, 0))
    __builtin_abort ();
#endif
}
