/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-O2 -std=c2x -pedantic-errors" } */

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
tests192 (_Decimal128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testu192 (_Decimal128 d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
tests575 (_Decimal128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testu575 (_Decimal128 d)
{
  return d;
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 192
  if (tests192 (0.DL) != 0wb
      || tests192 (0.9999999999999999999999999999999999DL) != 0wb
      || tests192 (7.999999999999999999999999999999999DL) != 7wb
      || tests192 (-0.DL) != 0wb
      || tests192 (-0.9999999999999999999999999999999999DL) != 0wb
      || tests192 (-1.DL) != -1wb
      || tests192 (-42.5DL) != -42wb
      || tests192 (-34242319854.45429439857871298745432e+27DL) != -34242319854454294398578712987454320000wb
      || tests192 (-213855087769445.9e+43DL) != -2138550877694459000000000000000000000000000000000000000000wb
      || tests192 (3138550867693340381917894711603833.0e+24DL) != 3138550867693340381917894711603833000000000000000000000000wb
      || tests192 (-3138550867693340381917894711603833.0e+24DL) != -3138550867693340381917894711603833000000000000000000000000wb)
    __builtin_abort ();
  if (tests192 (3138550867693340381917894711603834.0e+24DL) != 3138550867693340381917894711603833208051177722232017256447wb
      || tests192 (9999999999999999999999999999999999e+6111DL) != 3138550867693340381917894711603833208051177722232017256447wb
      || tests192 (-3138550867693340381917894711603834.0e+24DL) != -3138550867693340381917894711603833208051177722232017256447wb - 1wb
      || tests192 (-9999999999999999999999999999999999e+6111DL) != -3138550867693340381917894711603833208051177722232017256447wb - 1wb)
    __builtin_abort ();
  if (testu192 (0.DL) != 0uwb
      || testu192 (0.9999999999999999999999999999999999DL) != 0uwb
      || testu192 (-0.9999999999999999999999999999999999DL) != 0uwb
      || testu192 (-0.DL) != 0uwb
      || testu192 (-0.9999999999999999999999DL) != 0uwb
      || testu192 (-0.5DL) != 0uwb
      || testu192 (42.99999999999999999999999999999999DL) != 42uwb
      || testu192 (42.e+21DL) != 42000000000000000000000uwb
      || testu192 (34242319854.45429439857871298745432e+21DL) != 34242319854454294398578712987454uwb
      || testu192 (6277101735386680763835789423207666.0e+24DL) != 6277101735386680763835789423207666000000000000000000000000uwb)
    __builtin_abort ();
  if (testu192 (-1.DL) != 0uwb
      || testu192 (-42.5e+15DL) != 0uwb
      || testu192 (-9999999999999999999999999999999999e+6111DL) != 0uwb
      || testu192 (6277101735386680763835789423207667.0e+24DL) != 6277101735386680763835789423207666416102355444464034512895uwb
      || testu192 (9999999999999999999999999999999999e+6111DL) != 6277101735386680763835789423207666416102355444464034512895uwb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  if (tests575 (0.DL) != 0wb
      || tests575 (0.999999999999999999999DL) != 0wb
      || tests575 (12.99999999999999999999999999999DL) != 12wb
      || tests575 (-0.0000000000DL) != 0wb
      || tests575 (-0.9999999999999999999999999999999999DL) != 0uwb
      || tests575 (-1.DL) != -1wb
      || tests575 (-89.5DL) != -89wb
      || tests575 (-34242319854.45429986754986758972345e+37DL) != -342423198544542998675498675897234500000000000000wb
      || tests575 (-518326003682761.2e+158DL) != -51832600368276120000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb
      || tests575 (6183260036827613351512563025491179.0e+139DL) != 61832600368276133515125630254911790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb
      || tests575 (-6183260036827613351512563025491179.0e+139DL) != -61832600368276133515125630254911790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb)
    __builtin_abort ();
  if (tests575 (618326003682761335151256302549118.0e+140DL) != 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb
      || tests575 (9999999999999999999999999999999999e+6111DL) != 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb
      || tests575 (-6183260036827613351512563025491180.0e+139DL) != -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb
      || tests575 (-9999999999999999999999999999999999e+6111DL) != -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb)
    __builtin_abort ();
  if (testu575 (0.DL) != 0uwb
      || testu575 (0.5555555555555555555555555555555555DL) != 0uwb
      || testu575 (-0.7777777777777777777777777777777777DL) != 0uwb
      || testu575 (-0.99DL) != 0uwb
      || testu575 (-0.00000000000DL) != 0uwb
      || testu575 (42.99999999999999999999999999999999DL) != 42uwb
      || testu575 (42.e+21DL) != 42000000000000000000000uwb
      || testu575 (94272319854.45429e+27DL) != 94272319854454290000000000000000000000uwb
      || testu575 (1236652007365522670302512605098235.0e+140DL) != 123665200736552267030251260509823500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb)
    __builtin_abort ();
  if (testu575 (-1.DL) != 0uwb
      || testu575 (-42.5e+15DL) != 0uwb
      || testu575 (-9999999999999999999999999999999999e+6111DL) != 0uwb
      || testu575 (1236652007365522670302512605098236.0e+140DL) != 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb
      || testu575 (9999999999999999999999999999999999e+6111DL) != 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb)
    __builtin_abort ();
#endif
}
