/* do not edit automatically generated by mc from SArgs.  */
/* SArgs.mod provides a String interface to the command line arguments.

Copyright (C) 2001-2023 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _SArgs_H
#define _SArgs_C

#   include "GSYSTEM.h"
#   include "GUnixArgs.h"
#   include "GDynamicStrings.h"

typedef char *SArgs_PtrToChar;

typedef SArgs_PtrToChar *SArgs_PtrToPtrToChar;


/*
   GetArg - returns the nth argument from the command line.
            The success of the operation is returned.
            If TRUE is returned then the string, s, contains a
            new string, otherwise s is set to NIL.
*/

extern "C" unsigned int SArgs_GetArg (DynamicStrings_String *s, unsigned int n);

/*
   Narg - returns the number of arguments available from
          command line.
*/

extern "C" unsigned int SArgs_Narg (void);


/*
   GetArg - returns the nth argument from the command line.
            The success of the operation is returned.
            If TRUE is returned then the string, s, contains a
            new string, otherwise s is set to NIL.
*/

extern "C" unsigned int SArgs_GetArg (DynamicStrings_String *s, unsigned int n)
{
  int i;
  SArgs_PtrToPtrToChar ppc;

  i = (int ) (n);
  if (i < (UnixArgs_GetArgC ()))
    {
      /* ppc := ADDRESS (VAL (PtrToPtrToChar, ArgV) + (i * CARDINAL (TSIZE(PtrToChar)))) ;  */
      ppc = static_cast<SArgs_PtrToPtrToChar> ((void *) (((SArgs_PtrToChar) (UnixArgs_GetArgV ()))+(n*sizeof (SArgs_PtrToChar))));
      (*s) = DynamicStrings_InitStringCharStar (reinterpret_cast<void *> ((*ppc)));
      return TRUE;
    }
  else
    {
      (*s) = static_cast<DynamicStrings_String> (NULL);
      return FALSE;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Narg - returns the number of arguments available from
          command line.
*/

extern "C" unsigned int SArgs_Narg (void)
{
  return UnixArgs_GetArgC ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_SArgs_init (__attribute__((unused)) int argc,__attribute__((unused)) char *argv[],__attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_SArgs_fini (__attribute__((unused)) int argc,__attribute__((unused)) char *argv[],__attribute__((unused)) char *envp[])
{
}
