/* do not edit automatically generated by mc from TimeString.  */
/* TimeString.mod provides time related string manipulation procedures.

Copyright (C) 2001-2023 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _TimeString_H
#define _TimeString_C

#   include "Gwrapc.h"
#   include "GASCII.h"
#   include "GSYSTEM.h"


/*
   GetTimeString - places the time in ascii format into array, a.

*/

extern "C" void TimeString_GetTimeString (char *a, unsigned int _a_high);


/*
   GetTimeString - places the time in ascii format into array, a.

*/

extern "C" void TimeString_GetTimeString (char *a, unsigned int _a_high)
{
  typedef char *GetTimeString__T1;

  GetTimeString__T1 Addr;
  unsigned int i;

  Addr = static_cast<GetTimeString__T1> (wrapc_strtime ());
  i = 0;
  if (Addr != NULL)
    {
      while ((i < _a_high) && ((*Addr) != ASCII_nul))
        {
          a[i] = (*Addr);
          i += 1;
          Addr += 1;
        }
    }
  if (i < _a_high)
    {
      a[i] = ASCII_nul;
    }
}

extern "C" void _M2_TimeString_init (__attribute__((unused)) int argc,__attribute__((unused)) char *argv[],__attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_TimeString_fini (__attribute__((unused)) int argc,__attribute__((unused)) char *argv[],__attribute__((unused)) char *envp[])
{
}
