/* do not edit automatically generated by mc from mcPretty.  */
/* mcPretty.def provides an interface to the pretty printing of output code.

Copyright (C) 2016-2023 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_mcPretty_H)
#   define _mcPretty_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"

#   if defined (_mcPretty_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (mcPretty_pretty_D)
#  define mcPretty_pretty_D
   typedef void *mcPretty_pretty;
#endif

typedef struct mcPretty_writeProc_p mcPretty_writeProc;

typedef struct mcPretty_writeLnProc_p mcPretty_writeLnProc;

typedef void (*mcPretty_writeProc_t) (char);
struct mcPretty_writeProc_p { mcPretty_writeProc_t proc; };

typedef void (*mcPretty_writeLnProc_t) (void);
struct mcPretty_writeLnProc_p { mcPretty_writeLnProc_t proc; };


/*
   initPretty - initialise a pretty print data structure.
*/

EXTERN mcPretty_pretty mcPretty_initPretty (mcPretty_writeProc w, mcPretty_writeLnProc l);

/*
   dupPretty - duplicate a pretty print data structure.
*/

EXTERN mcPretty_pretty mcPretty_dupPretty (mcPretty_pretty p);

/*
   killPretty - destroy a pretty print data structure.
                Post condition:  p is assigned to NIL.
*/

EXTERN void mcPretty_killPretty (mcPretty_pretty *p);

/*
   pushPretty - duplicate, p.  Push, p, and return the duplicate.
*/

EXTERN mcPretty_pretty mcPretty_pushPretty (mcPretty_pretty p);

/*
   popPretty - pops the pretty object from the stack.
*/

EXTERN mcPretty_pretty mcPretty_popPretty (mcPretty_pretty p);

/*
   getindent - returns the current indent value.
*/

EXTERN unsigned int mcPretty_getindent (mcPretty_pretty p);

/*
   setindent - sets the current indent to, n.
*/

EXTERN void mcPretty_setindent (mcPretty_pretty p, unsigned int n);

/*
   getcurpos - returns the current cursor position.
*/

EXTERN unsigned int mcPretty_getcurpos (mcPretty_pretty s);

/*
   getseekpos - returns the seek position.
*/

EXTERN unsigned int mcPretty_getseekpos (mcPretty_pretty s);

/*
   getcurline - returns the current line number.
*/

EXTERN unsigned int mcPretty_getcurline (mcPretty_pretty s);

/*
   setNeedSpace - sets needSpace flag to TRUE.
*/

EXTERN void mcPretty_setNeedSpace (mcPretty_pretty s);

/*
   noSpace - unset needsSpace.
*/

EXTERN void mcPretty_noSpace (mcPretty_pretty s);

/*
   print - print a string using, p.
*/

EXTERN void mcPretty_print (mcPretty_pretty p, const char *a_, unsigned int _a_high);

/*
   prints - print a string using, p.
*/

EXTERN void mcPretty_prints (mcPretty_pretty p, DynamicStrings_String s);

/*
   raw - print out string, s, without any translation of
         escape sequences.
*/

EXTERN void mcPretty_raw (mcPretty_pretty p, DynamicStrings_String s);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
