#!/bin/bash

. setup.sh

cd $CVSCO
touch file4
cvs add file4
cvs commit -m "test commit"

cd $ABSDIR
gc-import -v -d $GIT_DIR $CVSROOT $CVSMODULE

cd $GCCO
mkdir -p test/foo/bar/
cd test/foo/bar/

git log

gc-update

git log | grep "test commit" || failure "Update from a subdirectory failed"

echo "FooBar" >> $GCCO/file4

git commit -m 'update commit from git' $GCCO/file4

gc-commit -c `git rev-list -n 1 HEAD` | grep "Committed successfully to CVS" || failure "Update from a subdirectory failed"


