#!/bin/sh
# Copyright (c) 2008 David Soria Parra <dsp at php dot net>
#
# Licensed under the terms of the MIT License
# See /usr/share/doc/gcutils/copyright
# or http://www.opensource.org/licenses/mit-license.php

. $LIBDIR$/gc-sh-setup

COMMANDS="gc-commit gc-import gc-multi-commit gc-update"

if test $# -lt 1
then
    echo "$PROGNAME: $VERSION"
    echo "available commands"
    for cmd in $COMMANDS
    do
	# whatis doesn't return a useful exit status, we have to check for strings
       output=`whatis $cmd | cut -b 4- | sed -e 's/([1-8])/   /'`
       (echo "$output" | grep -q "nothing appropriate") && output="$cmd"
       echo "  $output"
    done
    echo
else
    case "$1" in
        -V)
            version
            ;;
        help)
            for cmd in $COMMANDS
            do
                if test "$cmd" = "gc-$2"
                then
                    man $cmd
                    exit 0
                fi
            done
            echo "Command $2 not found" 1>&2
            exit 127
            ;;
        *)
            for cmd in $COMMANDS
            do
                if test "$cmd" = "gc-$1"
                then
                    shift
                    $cmd $*
                    exit 0
                fi
            done
            echo "Command $1 not found" 1>&2
            exit 127
            ;;
    esac
fi
