#!/bin/sh
# Copyright (c) 2007 David Soria Parra <dsp at php dot net>
#
# Licensed under the terms of the MIT License
# See /usr/share/doc/gcutils/copyright
# or http://www.opensource.org/licenses/mit-license.php

. $LIBDIR$/gc-sh-setup

usage ()
{
    echo "Usage:" `basename $0`" [OPTIONS] <sha1>"
    echo "Options are:"
    echo "    -h            show help"
    echo "    -v            verbosity"
    echo "    -a            commit all differences without being asked"
    echo "                  WARNING: use this option with caution"
    echo "    -V            show version information"
    echo
    exit 127
}

selecting ()
{
    RESULT=""
    while true
    do
        i=1
        for word in $WORDS
        do
            echo "${i}) $word"
            description

            i=`expr $i + 1`
        done
        echo -n "Select> "
        read select

        test $i -gt $select && break
    done
    i=1
    for word in $WORDS
    do
        if test $i -eq $select
        then
            RESULT=$word
            break
        fi
        i=`expr $i + 1`
    done
}

description ()
{
    echo $word | grep -E "[a-f0-9]{40}" >/dev/null && echo -n "   " && git --no-pager log -n 1 --pretty=format:"%s" $word && echo
}

help ()
{
    echo "Interactive git to cvs commiter"
    echo
    echo "Please use CTR+<RETURN> in the menu select prompt"
    echo
}

cont ()
{
    while true
    do
        echo -n "Sure? [yn] "
        read in
        test "$in" = "n" && return 1
        test "$in" = "y" && return 0
    done
}

check_git

remote=`git config gc-utils.remote`

test -n "$remote" && refspec="refs/remotes/$remote/master" || refspec="refs/heads/origin"

verbose=
while test $# != 0
do
    case "$1" in
    -h)
        usage
        ;;
    -V)
        version
        exit
        ;;
    -v)
        verbose="-v"
        ;;
    -a)
        git cherry $refspec | sed -n 's/^+ //p' | xargs -l1 gc-commit -c
        exit
        ;;
    esac
    shift
done

locate_git_repo

if test ! -d ".cvs" -o ! -d ".cvs/CVS/"
then
    echo >&2 "CVS working directory not found."
    die "Make sure you imported your CVS repository using gc-import."
fi

git branch 2>/dev/null || die "not a repository"

while true
do
    echo
    echo "Menu ---------------------------------------"
    echo "Use CTRL+<RETURN>"
    WORDS="`git cherry $refspec | grep -o -E "[0-9a-f]{40}"` exit help"; selecting; sha=$RESULT
    test -z "$sha" && die "not found"
    test "$sha" = "exit" && exit

    if test "$sha" = "help"
    then
        help
    else
        while true
        do
            echo
            WORDS="log diff commit abort"; selecting; action=$RESULT
            if test "$action" = "log"
            then
                git log -n 1 $sha
            elif test "$action" = "diff"
            then
                git show $sha
            elif test "$action" = "commit"
            then
                cont && gc-commit -c $sha
            elif test "$action" = "abort"
            then
                break
            fi
        done
    fi
done
