#ifndef MKCF_H
#define MKCF_H

/*
 * mkcf.h - modify a userprefs.h configuration file
 *
 * include LICENSE
 */

#include <dlist.h>
#include <arraystr.h>
#include <filerec.h>

typedef struct _UserData UserData;

struct _UserData {
   char *prog;
   int nflag;         /* create a new userprefs.h file */ 
   int cflag;         /* write variable with extracted comments */ 
   int pflag;         /* preserve input file */ 
   int fcflag;        /* force comment from var if any */ 
   int verbose;       /* verbose level */ 
   int nouv;          /* there is no "User variables", start search variable after struct _UserPrefs */
   
   int  defmarkerflag;  /* set to 1 if defmarker is used to search */  
   char *defmarker;     /* def : "THIS_IS_USERPREFS_FILE" */  
   char *searchmarker;  /* string to search before looking for variables */
   char *endmarker;     /* end marker : no search after */
   char *defdesc;       /* def : "ConfigDescTable" */
   char *searchdesc;    /* string to search for a ConfigDescTable */
   char *rcfile;        /* rc file name */
   char *upproto;       /* user pref prototype ie: UserPrefs */

   FILE *ofd;          /* currrent output file descriptor */
   DList *filerecs;    /* list of all files scanned */
   DList *descrecs;    /* list for conf desc records */
   DList *tinirecs;    /* list of files related to tini variables  */
   DList *includes;    /* list of include file name  */
   ArrayStr *initfuncs;  /* init functions array */
   int mkcfVersion;    /* a iteration number raed in the Prefs */
};

/*
 * prototypes
 */
void mkcf_write_empty_file (UserData *ud);
void mkcf_destroy(UserData *ud);
void mkcf_extract_var_from_file( UserData *ud, char *rcfile, char *proto,
				 char *svarn,  char *relvar );
int mkcf_iter_extract_var_for_tini( AppClass *data, void *user_data );
void mkcf_extract_conf_desc_table(UserData *ud);
void mkcf_write_new_user_prefs(UserData *ud);
void mkcf_check_include(UserData *ud, FileRecord *frec, char *rcfile);

#endif /* MKCF_H */
