#ifndef FILEREC_H
#define FILEREC_H

/*
 * filerec.h - filerec protocol interface
 * 
 * include LICENSE
 */

#include <dlist.h>

typedef struct _FileRecord FileRecord;

struct _FileRecord {
   AppClass parent;
   char *rcfile;      /* name of the file */
   char *proto;       /* prototype for struct holding vars */
   char *svarn;       /* short variable name - ex: up for userPrefs */
   char *relvar;      /* variable that requested this */
   char *prefix;      /* a prefix for var name */
   char *funcname;    /* prefix to functions of variable relvar */
   char *descname;    /* comuted from relvar */
   void *user_data;   /* pointer to ud */
   DList *vars;       /* list of variables in the structure */
   DList *includes;   /* list of include directives in userprefs.h   */
};

/*
 * prototypes
 */
FileRecord *filerec_new( char *rcfile, char *proto, char *svarn, char *relvar );
void filerec_construct( FileRecord *frec,  char *rcfile, char *proto,
			char *svarn, char *relvar );
void filerec_destroy(void *frec);

void filerec_lower(char *name);
void filerec_dup_svarn( FileRecord *frec, char *svarn );
void filerec_dup_prefix( FileRecord *frec, char *prefix );
void filerec_add_var( FileRecord *frec, char *varname, char *vartype,
		      char *varcmt, int tini, int lineno );
char *filerec_get_prefix(FileRecord *frec);

void filerec_dup_descname(FileRecord *frec, char *descname);
void filerec_dup_funcname(FileRecord *frec, char *name);
int filerec_iter_print_vars( AppClass *data, void *user_data );
int filerec_iter_print_prototypes( AppClass *data, void *user_data );
int filerec_iter_print_content( AppClass *data, void *user_data );
int filerec_proto_cmp(AppClass *d1, AppClass *d2 );
int filerec_relvar_cmp(AppClass *d1, AppClass *d2 );

#endif /* FILEREC_H */
