#ifndef DESCELEM_H
#define DESCELEM_H

/*
 * descelem.h -  hold a conf desc table entry
 * 
 * include LICENSE
 */

#include <appclass.h>

typedef struct _DescElem DescElem;

struct _DescElem {
   AppClass parent;
   char *extTok;   /* name seen in conf file */
   char *varfunc;  /* name of function to get var addr */
   char *desctype; /* type of entry */
   char *desccmt;  /* a comment that will be output in conf file */
   char *varname;  /* variable name ectracted from varfunc */
   int  lineno;    /* line number in userpref.h */
};

/*
 * prototypes
 */
DescElem *descelem_new( char *extTok, char *varfunc, char *desctype,
			char *desccmt, int lineno );
void descelem_construct( DescElem *elem, char *extTok, char *varfunc,
			 char *desctype, char *desccmt, int lineno);
void descelem_destroy(void *elem);

void descelem_dup_varname(DescElem *elem , char *varname);
int descelem_iter_print_elem( AppClass *data, void *user_data );
int descelem_name_cmp(AppClass *d1, AppClass *d2 );
void descelem_set_desctype(DescElem *elem , char *desctype);

char *descelem_convert_type( char *text);

int descelem_extTok_cmp(AppClass *d1, AppClass *d2 );

#endif /* DESCELEM_H */
