/*----------------------
   Copyright (C): OpenGATE Collaboration

This software is distributed under the terms
of the GNU Lesser General  Public Licence (LGPL)
See GATE/LICENSE.txt for further details
----------------------*/

/*!
  \file   GateNTLEMuEnDatabase
  \brief  Database of MuEn
  \authors: Halima Elazhar (halima.elazhar@ihpc.cnrs.fr)
            Thomas Deschler (thomas.deschler@iphc.cnrs.fr)
*/

#ifndef GATENTLEMUENDATABASE_HH
#define GATENTLEMUENDATABASE_HH

#include <vector>

//-----------------------------------------------------------------------------
static const std::vector<double> energyTableTLE = { // MeV
1.00000E-03,
1.03542E-03,
1.07210E-03,
1.07210E-03,
1.50000E-03,
2.00000E-03,
2.14550E-03,
2.14550E-03,
2.30297E-03,
2.47200E-03,
2.47200E-03,
2.64140E-03,
2.82240E-03,
2.82240E-03,
3.00000E-03,
3.60740E-03,
3.60740E-03,
4.00000E-03,
5.00000E-03,
6.00000E-03,
8.00000E-03,
1.00000E-02,
1.50000E-02,
2.00000E-02,
3.00000E-02,
4.00000E-02,
5.00000E-02,
6.00000E-02,
8.00000E-02,
1.00000E-01,
1.50000E-01,
2.00000E-01,
3.00000E-01,
4.00000E-01,
5.00000E-01,
6.00000E-01,
8.00000E-01,
1.00000E+00,
1.25000E+00,
1.50000E+00,
2.00000E+00,
3.00000E+00,
4.00000E+00,
5.00000E+00,
6.00000E+00,
8.00000E+00,
1.00000E+01,
1.50000E+01,
2.00000E+01
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> energyTableTLE_ICRU44 = { // MeV
0.01,
0.015,
0.02,
0.03,
0.04,
0.05,
0.06,
0.08,
0.1,
0.15,
0.2,
0.3,
0.4,
0.5,
0.6,
0.8,
1,
1.5,
2,
3,
4,
5,
6,
8,
10,
15,
20,
30,
40,
50,
60,
80,
100
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> energyTableTLE_NIST = { // MeV
1.000E-3,
1.500E-3,
2.000E-3,
3.000E-3,
4.000E-3,
5.000E-3,
6.000E-3,
8.000E-3,
1.000E-2,
1.500E-2,
2.000E-2,
3.000E-2,
4.000E-2,
5.000E-2,
6.000E-2,
8.000E-2,
1.000E-1,
1.500E-1,
2.000E-1,
3.000E-1,
4.000E-1,
5.000E-1,
6.000E-1,
8.000E-1,
1.000E+0,
1.250E+0,
1.500E+0,
2.000E+0,
3.000E+0,
4.000E+0,
5.000E+0,
6.000E+0,
8.000E+0,
1.000E+1,
1.500E+1,
2.000E+1
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEnTableHydrogen =  { // cm²/g
6.820E+0,
1.752E+0,
6.643E-1,
1.693E-1,
6.549E-2,
3.278E-2,
1.996E-2,
1.160E-2,
9.849E-3,
1.102E-2,
1.355E-2,
1.863E-2,
2.315E-2,
2.709E-2,
3.053E-2,
3.620E-2,
4.063E-2,
4.813E-2,
5.254E-2,
5.695E-2,
5.860E-2,
5.900E-2,
5.875E-2,
5.739E-2,
5.556E-2,
5.311E-2,
5.075E-2,
4.650E-2,
3.992E-2,
3.523E-2,
3.174E-2,
2.905E-2,
2.515E-2,
2.247E-2,
1.837E-2,
1.606E-2
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEnMuscleTable =  { // cm²/g
3.709E+03,
3.383E+03,
3.085E+03,
3.091E+03,
1.247E+03,
5.574E+02,
4.564E+02,
4.606E+02,
3.762E+02,
3.069E+02,
3.121E+02,
2.579E+02,
2.130E+02,
2.143E+02,
1.796E+02,
1.046E+02,
1.083E+02,
7.992E+01,
4.116E+01,
2.377E+01,
9.888E+00,
4.964E+00,
1.396E+00,
5.638E-01,
1.610E-01,
7.192E-02,
4.349E-02,
3.258E-02,
2.615E-02,
2.544E-02,
2.745E-02,
2.942E-02,
3.164E-02,
3.249E-02,
3.269E-02,
3.254E-02,
3.177E-02,
3.074E-02,
2.938E-02,
2.808E-02,
2.584E-02,
2.259E-02,
2.045E-02,
1.895E-02,
1.786E-02,
1.639E-02,
1.547E-02,
1.421E-02,
1.361E-02
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEnLungTable =  {
3.791E+03,
3.459E+03,
3.155E+03,
3.167E+03,
1.280E+03,
5.727E+02,
4.690E+02,
4.732E+02,
3.865E+02,
3.154E+02,
3.206E+02,
2.650E+02,
2.189E+02,
2.229E+02,
1.870E+02,
1.091E+02,
1.110E+02,
8.181E+01,
4.210E+01,
2.431E+01,
1.010E+01,
5.067E+00,
1.423E+00,
5.740E-01,
1.635E-01,
7.286E-02,
4.393E-02,
3.282E-02,
2.625E-02,
2.550E-02,
2.748E-02,
2.945E-02,
3.167E-02,
3.252E-02,
3.272E-02,
3.257E-02,
3.179E-02,
3.077E-02,
2.940E-02,
2.810E-02,
2.586E-02,
2.262E-02,
2.048E-02,
1.898E-02,
1.789E-02,
1.643E-02,
1.551E-02,
1.427E-02,
1.367E-02
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEnCorticalBoneTable =  {
3.772E+03,
3.444E+03,
3.143E+03,
3.149E+03,
2.429E+03,
1.869E+03,
1.878E+03,
1.291E+03,
5.846E+02,
4.803E+02,
6.961E+02,
5.789E+02,
4.805E+02,
4.857E+02,
2.897E+02,
1.303E+02,
1.269E+02,
3.006E+02,
1.757E+02,
1.085E+02,
4.987E+01,
2.680E+01,
8.388E+00,
3.601E+00,
1.070E+00,
4.507E-01,
2.336E-01,
1.400E-01,
6.896E-02,
4.585E-02,
3.183E-02,
3.003E-02,
3.032E-02,
3.069E-02,
3.073E-02,
3.052E-02,
2.973E-02,
2.875E-02,
2.745E-02,
2.623E-02,
2.421E-02,
2.145E-02,
1.975E-02,
1.864E-02,
1.788E-02,
1.695E-02,
1.644E-02,
1.587E-02,
1.568E-02
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEnVacuumTable =  {
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.,
0.
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_ICRU44_Lung_Griffith_Table =  {
4.57E-01,
1.34E-01,
5.57E-02,
1.67E-02,
7.64E-03,
4.63E-03,
3.43E-03,
2.68E-03,
2.56E-03,
2.71E-03,
2.89E-03,
3.10E-03,
3.19E-03,
3.20E-03,
3.19E-03,
3.11E-03,
3.01E-03,
2.75E-03,
2.53E-03,
2.21E-03,
1.99E-03,
1.84E-03,
1.73E-03,
1.58E-03,
1.49E-03,
1.36E-03,
1.30E-03,
1.24E-03,
1.21E-03,
1.19E-03,
1.17E-03,
1.15E-03,
1.13E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_ICRU44_Air_Table = {
4.65E-01,
1.30E-01,
5.27E-02,
1.50E-02,
6.71E-03,
4.04E-03,
3.01E-03,
2.40E-03,
2.32E-03,
2.49E-03,
2.67E-03,
2.87E-03,
2.95E-03,
2.97E-03,
2.95E-03,
2.88E-03,
2.79E-03,
2.54E-03,
2.34E-03,
2.05E-03,
1.87E-03,
1.74E-03,
1.64E-03,
1.52E-03,
1.45E-03,
1.35E-03,
1.31E-03,
1.28E-03,
1.25E-03,
1.24E-03,
1.22E-03,
1.20E-03,
1.19E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_Adipose_tissue_Adult_1_ICRU46_tableau = {
3.13E-01,
8.65E-02,
3.47E-02,
1.01E-02,
4.81E-03,
3.20E-03,
2.63E-03,
2.38E-03,
2.44E-03,
2.74E-03,
2.96E-03,
3.19E-03,
3.28E-03,
3.30E-03,
3.28E-03,
3.20E-03,
3.10E-03,
2.83E-03,
2.60E-03,
2.27E-03,
2.05E-03,
1.89E-03,
1.77E-03,
1.61E-03,
1.51E-03,
1.37E-03,
1.31E-03,
1.24E-03,
1.21E-03,
1.19E-03,
1.16E-03,
1.14E-03,
1.12E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_Blood_Adult_ICRU46_tableau = {
4.99E-01,
1.41E-01,
5.70E-02,
1.63E-02,
7.30E-03,
4.41E-03,
3.29E-03,
2.63E-03,
2.55E-03,
2.75E-03,
2.94E-03,
3.16E-03,
3.25E-03,
3.27E-03,
3.25E-03,
3.18E-03,
3.07E-03,
2.80E-03,
2.58E-03,
2.26E-03,
2.04E-03,
1.89E-03,
1.79E-03,
1.64E-03,
1.55E-03,
1.43E-03,
1.37E-03,
1.31E-03,
1.28E-03,
1.27E-03,
1.24E-03,
1.22E-03,
1.20E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_GI_track_intestine_Adult_ICRU46_tableau = {
4.68E-01,
1.30E-01,
5.24E-02,
1.49E-02,
6.71E-03,
4.11E-03,
3.13E-03,
2.57E-03,
2.53E-03,
2.75E-03,
2.95E-03,
3.17E-03,
3.26E-03,
3.28E-03,
3.27E-03,
3.19E-03,
3.08E-03,
2.82E-03,
2.59E-03,
2.26E-03,
2.05E-03,
1.90E-03,
1.79E-03,
1.64E-03,
1.55E-03,
1.42E-03,
1.37E-03,
1.30E-03,
1.28E-03,
1.26E-03,
1.24E-03,
1.21E-03,
1.19E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_Lymph_Adult_ICRU46_ICRU46_tableau = {
4.96E-01,
1.38E-01,
5.56E-02,
1.58E-02,
7.05E-03,
4.28E-03,
3.22E-03,
2.61E-03,
2.55E-03,
2.76E-03,
2.96E-03,
3.18E-03,
3.27E-03,
3.29E-03,
3.27E-03,
3.19E-03,
3.09E-03,
2.82E-03,
2.59E-03,
2.27E-03,
2.06E-03,
1.91E-03,
1.80E-03,
1.65E-03,
1.56E-03,
1.44E-03,
1.38E-03,
1.32E-03,
1.29E-03,
1.28E-03,
1.25E-03,
1.23E-03,
1.21E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_Skeleton_cartilage_Adult_ICRU46_tableau = {
5.85E-01,
1.66E-01,
6.72E-02,
1.92E-02,
8.43E-03,
4.96E-03,
3.59E-03,
2.74E-03,
2.60E-03,
2.75E-03,
2.93E-03,
3.15E-03,
3.23E-03,
3.25E-03,
3.23E-03,
3.16E-03,
3.05E-03,
2.79E-03,
2.56E-03,
2.25E-03,
2.04E-03,
1.89E-03,
1.78E-03,
1.64E-03,
1.55E-03,
1.43E-03,
1.38E-03,
1.32E-03,
1.30E-03,
1.28E-03,
1.26E-03,
1.24E-03,
1.21E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_Skeleton_spongiosa_Adult_ICRU46_tableau = {
1.11E+00,
3.39E-01,
1.44E-01,
4.28E-02,
1.84E-02,
1.00E-02,
6.47E-03,
3.91E-03,
3.17E-03,
2.89E-03,
2.97E-03,
3.13E-03,
3.20E-03,
3.22E-03,
3.20E-03,
3.12E-03,
3.02E-03,
2.76E-03,
2.54E-03,
2.22E-03,
2.02E-03,
1.88E-03,
1.77E-03,
1.64E-03,
1.55E-03,
1.44E-03,
1.39E-03,
1.34E-03,
1.32E-03,
1.29E-03,
1.27E-03,
1.25E-03,
1.23E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_Skin_Adult_ICRU46_tableau = {
4.47E-01,
1.25E-01,
5.02E-02,
1.44E-02,
6.49E-03,
4.00E-03,
3.06E-03,
2.54E-03,
2.50E-03,
2.73E-03,
2.93E-03,
3.16E-03,
3.24E-03,
3.26E-03,
3.25E-03,
3.17E-03,
3.07E-03,
2.80E-03,
2.58E-03,
2.25E-03,
2.04E-03,
1.89E-03,
1.78E-03,
1.63E-03,
1.54E-03,
1.41E-03,
1.35E-03,
1.29E-03,
1.27E-03,
1.25E-03,
1.22E-03,
1.20E-03,
1.18E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_Testis_Adult_ICRU46_tableau = {
4.86E-01,
1.36E-01,
5.47E-02,
1.56E-02,
6.98E-03,
4.25E-03,
3.20E-03,
2.60E-03,
2.54E-03,
2.75E-03,
2.95E-03,
3.18E-03,
3.26E-03,
3.28E-03,
3.27E-03,
3.19E-03,
3.08E-03,
2.81E-03,
2.59E-03,
2.26E-03,
2.05E-03,
1.90E-03,
1.79E-03,
1.64E-03,
1.55E-03,
1.43E-03,
1.37E-03,
1.31E-03,
1.29E-03,
1.27E-03,
1.24E-03,
1.22E-03,
1.20E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_Urinary_bladder_empty_Adult_ICRU46_tableau = {
5.02E-01,
1.41E-01,
5.68E-02,
1.62E-02,
7.23E-03,
4.37E-03,
3.27E-03,
2.62E-03,
2.55E-03,
2.75E-03,
2.95E-03,
3.17E-03,
3.26E-03,
3.28E-03,
3.26E-03,
3.18E-03,
3.08E-03,
2.81E-03,
2.59E-03,
2.26E-03,
2.05E-03,
1.90E-03,
1.79E-03,
1.64E-03,
1.55E-03,
1.43E-03,
1.37E-03,
1.31E-03,
1.29E-03,
1.27E-03,
1.24E-03,
1.22E-03,
1.20E-03
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> MuEn_ICRU_Soft_Tissue_NIST = { // cm²/g
3.818E+03,
1.283E+03,
5.736E+02,
1.781E+02,
7.598E+01,
3.880E+01,
2.226E+01,
9.163E+00,
4.564E+00,
1.266E+00,
5.070E-01,
1.438E-01,
6.474E-02,
3.987E-02,
3.051E-02,
2.530E-02,
2.501E-02,
2.732E-02,
2.936E-02,
3.161E-02,
3.247E-02,
3.267E-02,
3.252E-02,
3.175E-02,
3.073E-02,
2.937E-02,
2.806E-02,
2.582E-02,
2.258E-02,
2.044E-02,
1.894E-02,
1.785E-02,
1.638E-02,
1.546E-02,
1.420E-02,
1.360E-02
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> energyTableKEF = { // MeV (Photons kerma equivalent factors from A.G Aleksev 1986)
1.10E-04,
2.00E-04,
3.60E-04,
6.30E-04,
1.10E-03,
2.00E-03,
3.60E-03,
6.30E-03,
1.10E-02,
2.00E-02,
3.60E-02,
6.30E-02,
8.20E-02,
8.60E-02,
9.00E-02,
9.40E-02,
9.80E-02,
1.05E-01,
1.15E-01,
1.25E-01,
1.35E-01,
1.45E-01,
1.55E-01,
1.65E-01,
1.75E-01,
1.85E-01,
1.95E-01,
2.10E-01,
2.30E-01,
2.50E-01,
2.70E-01,
2.90E-01,
3.10E-01,
3.30E-01,
3.50E-01,
3.70E-01,
3.90E-01,
4.20E-01,
4.60E-01,
5.00E-01,
5.40E-01,
5.80E-01,
6.20E-01,
6.60E-01,
7.00E-01,
7.40E-01,
7.80E-01,
8.20E-01,
8.60E-01,
9.00E-01,
9.40E-01,
9.80E-01,
1.05E+00,
1.15E+00,
1.25E+00,
1.35E+00,
1.45E+00,
1.55E+00,
1.65E+00,
1.75E+00,
1.85E+00,
1.95E+00,
2.10E+00,
2.30E+00,
2.50E+00,
2.70E+00,
2.90E+00,
3.10E+00,
3.30E+00,
3.50E+00,
3.70E+00,
3.90E+00,
4.20E+00,
4.60E+00,
5.00E+00,
5.40E+00,
5.80E+00,
6.20E+00,
6.60E+00,
7.00E+00,
7.40E+00,
7.80E+00,
8.20E+00,
8.60E+00,
9.00E+00,
9.40E+00,
9.80E+00,
1.05E+01,
1.15E+01,
1.25E+01,
1.35E+01,
1.45E+01,
1.55E+01,
1.65E+01,
1.75E+01,
1.85E+01,
1.95E+01
};
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
static const std::vector<double> KEF_ICRUSoftTissue = { // Sv.m² (Photons kerma equivalent factors from A.G Aleksev 1986)
3.87E-13,
2.10E-13,
2.10E-13,
6.70E-13,
2.71E-13,
7.25E-14,
1.91E-14,
4.52E-15,
1.10E-15,
2.28E-16,
7.88E-17,
5.01E-17,
5.32E-17,
5.45E-17,
5.58E-17,
5.69E-17,
5.87E-17,
6.19E-17,
6.62E-17,
7.09E-17,
7.62E-17,
8.11E-17,
8.60E-17,
9.19E-17,
9.68E-17,
1.02E-16,
1.08E-16,
1.16E-16,
1.28E-16,
1.38E-16,
1.50E-16,
1.60E-16,
1.72E-16,
1.83E-16,
1.94E-16,
2.04E-16,
2.16E-16,
2.31E-16,
2.53E-16,
2.74E-16,
2.93E-16,
3.14E-16,
3.31E-16,
3.48E-16,
3.65E-16,
3.82E-16,
3.99E-16,
4.13E-16,
4.25E-16,
4.36E-16,
4.48E-16,
4.60E-16,
4.95E-16,
5.51E-16,
5.88E-16,
6.23E-16,
6.57E-16,
6.89E-16,
7.19E-16,
7.50E-16,
7.80E-16,
8.11E-16,
8.52E-16,
9.04E-16,
9.55E-16,
1.01E-15,
1.06E-15,
1.11E-15,
1.15E-15,
1.20E-15,
1.24E-15,
1.29E-15,
1.35E-15,
1.43E-15,
1.52E-15,
1.60E-15,
1.68E-15,
1.75E-15,
1.83E-15,
1.91E-15,
1.98E-15,
2.06E-15,
2.14E-15,
2.21E-15,
2.29E-15,
2.36E-15,
2.44E-15,
2.57E-15,
2.75E-15,
2.94E-15,
3.13E-15,
3.32E-15,
3.50E-15,
3.70E-15,
3.89E-15,
4.08E-15,
4.27E-15
};
//-----------------------------------------------------------------------------


#endif
