(include "#.scm")

(define (obj->str obj printer style)
  (with-output-to-string
   ""
   (lambda ()
     (output-port-readtable-set!
      (current-output-port)
      (readtable-sharing-allowed?-set
       (output-port-readtable (current-output-port))
       style))
     (printer obj))))

(define obj1
  (list 123
        -45678901234567890
        1.25
        #t
        #f
        #\space
        "hello\nworld"
        'sym
        'key:
        '#(1 2 3)
        '(1 2 . 3)
        '()))

(define obj2
  (let* ((a obj1)
         (b (list a a))
         (c (vector b b)))
    (cons c '())))

(check-equal?
 (obj->str obj1 write #f)
 "(123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ())")

(check-equal?
 (obj->str obj1 write #t)
 "(123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ())")

(check-equal?
 (obj->str obj1 write 'serialize)
 "(123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ())")

(check-equal?
 (obj->str obj1 display #f)
 "(123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ())")

(check-equal?
 (obj->str obj1 display #t)
 "(123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ())")

(check-equal?
 (obj->str obj1 display 'serialize)
 "(123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ())")

(check-equal?
 (obj->str obj1 pretty-print #f)
 "(123\n -45678901234567890\n 1.25\n #t\n #f\n #\\space\n \"hello\\nworld\"\n sym\n key:\n #(1 2 3)\n (1 2 . 3)\n ())\n")

(check-equal?
 (obj->str obj1 pretty-print #t)
 "(123\n -45678901234567890\n 1.25\n #t\n #f\n #\\space\n \"hello\\nworld\"\n sym\n key:\n #(1 2 3)\n (1 2 . 3)\n ())\n")

(check-equal?
 (obj->str obj1 pretty-print 'serialize)
 "(123\n -45678901234567890\n 1.25\n #t\n #f\n #\\space\n \"hello\\nworld\"\n sym\n key:\n #(1 2 3)\n (1 2 . 3)\n ())\n")



(check-equal?
 (obj->str obj2 write #f)
 "(#(((123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ()) (123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ())) ((123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ()) (123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ()))))")

(check-equal?
 (obj->str obj2 write #t)
 "(#(#0=(#1=(123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ()) #1#) #0#))")

(check-equal?
 (obj->str obj2 write 'serialize)
 "(#(#0=(#1=(123 -45678901234567890 1.25 #t #f #\\space \"hello\\nworld\" sym key: #(1 2 3) (1 2 . 3) ()) #1#) #0#))")

(check-equal?
 (obj->str obj2 display #f)
 "(#(((123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ()) (123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ())) ((123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ()) (123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ()))))")

(check-equal?
 (obj->str obj2 display #t)
 "(#(#0=(#1=(123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ()) #1#) #0#))")

(check-equal?
 (obj->str obj2 display 'serialize)
 "(#(#0=(#1=(123 -45678901234567890 1.25 #t #f   hello\nworld sym key #(1 2 3) (1 2 . 3) ()) #1#) #0#))")

(check-equal?
 (obj->str obj2 pretty-print #f)
 "(#(((123\n     -45678901234567890\n     1.25\n     #t\n     #f\n     #\\space\n     \"hello\\nworld\"\n     sym\n     key:\n     #(1 2 3)\n     (1 2 . 3)\n     ())\n    (123\n     -45678901234567890\n     1.25\n     #t\n     #f\n     #\\space\n     \"hello\\nworld\"\n     sym\n     key:\n     #(1 2 3)\n     (1 2 . 3)\n     ()))\n   ((123\n     -45678901234567890\n     1.25\n     #t\n     #f\n     #\\space\n     \"hello\\nworld\"\n     sym\n     key:\n     #(1 2 3)\n     (1 2 . 3)\n     ())\n    (123\n     -45678901234567890\n     1.25\n     #t\n     #f\n     #\\space\n     \"hello\\nworld\"\n     sym\n     key:\n     #(1 2 3)\n     (1 2 . 3)\n     ()))))\n")

(check-equal?
 (obj->str obj2 pretty-print #t)
 "(#(#0=(#1=(123\n           -45678901234567890\n           1.25\n           #t\n           #f\n           #\\space\n           \"hello\\nworld\"\n           sym\n           key:\n           #(1 2 3)\n           (1 2 . 3)\n           ())\n       #1#)\n   #0#))\n")

(check-equal?
 (obj->str obj2 pretty-print 'serialize)
 "(#(#0=(#1=(123\n           -45678901234567890\n           1.25\n           #t\n           #f\n           #\\space\n           \"hello\\nworld\"\n           sym\n           key:\n           #(1 2 3)\n           (1 2 . 3)\n           ())\n       #1#)\n   #0#))\n")

(set-cdr! obj2 obj2)

(check-equal?
 (obj->str obj2 pretty-print 'serialize)
 "#0=(#(#1=(#2=(123\n              -45678901234567890\n              1.25\n              #t\n              #f\n              #\\space\n              \"hello\\nworld\"\n              sym\n              key:\n              #(1 2 3)\n              (1 2 . 3)\n              ())\n          #2#)\n      #1#)\n    .\n    #0#)\n")

(define (shared n x)
  (if (> n 0)
      (let ((y (shared (- n 1) x)))
        (list y (list (shared (- n 1) y))))
      x))

(check-equal?
 (obj->str (shared 0 'foobar) pretty-print #t)
 "foobar\n")

(check-equal?
 (obj->str (shared 1 'foobar) pretty-print #t)
 "(foobar (foobar))\n")

(check-equal?
 (obj->str (shared 2 'foobar) pretty-print #t)
 "(#0=(foobar (foobar)) ((#0# (#0#))))\n")

(check-equal?
 (obj->str (shared 3 'foobar) pretty-print #t)
 "(#0=(#1=(foobar (foobar)) ((#1# (#1#)))) ((#2=(#0# (#0#)) ((#2# (#2#))))))\n")

(check-equal?
 (obj->str (shared 4 'foobar) pretty-print #t)
 "(#0=(#1=(#2=(foobar (foobar)) ((#2# (#2#)))) ((#3=(#1# (#1#)) ((#3# (#3#))))))\n ((#4=(#5=(#0# (#0#)) ((#5# (#5#)))) ((#6=(#4# (#4#)) ((#6# (#6#))))))))\n")

(check-equal?
 (obj->str (shared 5 'foobar) pretty-print #t)
 "(#0=(#1=(#2=(#3=(foobar (foobar)) ((#3# (#3#))))\n         ((#4=(#2# (#2#)) ((#4# (#4#))))))\n     ((#5=(#6=(#1# (#1#)) ((#6# (#6#)))) ((#7=(#5# (#5#)) ((#7# (#7#))))))))\n ((#8=(#9=(#10=(#0# (#0#)) ((#10# (#10#))))\n       ((#11=(#9# (#9#)) ((#11# (#11#))))))\n   ((#12=(#13=(#8# (#8#)) ((#13# (#13#))))\n     ((#14=(#12# (#12#)) ((#14# (#14#))))))))))\n")

(check-equal?
 (obj->str (shared 6 'foobar) pretty-print #t)
 "(#0=(#1=(#2=(#3=(#4=(foobar (foobar)) ((#4# (#4#))))\n             ((#5=(#3# (#3#)) ((#5# (#5#))))))\n         ((#6=(#7=(#2# (#2#)) ((#7# (#7#))))\n           ((#8=(#6# (#6#)) ((#8# (#8#))))))))\n     ((#9=(#10=(#11=(#1# (#1#)) ((#11# (#11#))))\n           ((#12=(#10# (#10#)) ((#12# (#12#))))))\n       ((#13=(#14=(#9# (#9#)) ((#14# (#14#))))\n         ((#15=(#13# (#13#)) ((#15# (#15#))))))))))\n ((#16=(#17=(#18=(#19=(#0# (#0#)) ((#19# (#19#))))\n             ((#20=(#18# (#18#)) ((#20# (#20#))))))\n        ((#21=(#22=(#17# (#17#)) ((#22# (#22#))))\n          ((#23=(#21# (#21#)) ((#23# (#23#))))))))\n   ((#24=(#25=(#26=(#16# (#16#)) ((#26# (#26#))))\n          ((#27=(#25# (#25#)) ((#27# (#27#))))))\n     ((#28=(#29=(#24# (#24#)) ((#29# (#29#))))\n       ((#30=(#28# (#28#)) ((#30# (#30#))))))))))))\n")

(check-equal?
 (obj->str (shared 7 'foobar) pretty-print #t)
 "(#0=(#1=(#2=(#3=(#4=(#5=(foobar (foobar)) ((#5# (#5#))))\n                 ((#6=(#4# (#4#)) ((#6# (#6#))))))\n             ((#7=(#8=(#3# (#3#)) ((#8# (#8#))))\n               ((#9=(#7# (#7#)) ((#9# (#9#))))))))\n         ((#10=(#11=(#12=(#2# (#2#)) ((#12# (#12#))))\n                ((#13=(#11# (#11#)) ((#13# (#13#))))))\n           ((#14=(#15=(#10# (#10#)) ((#15# (#15#))))\n             ((#16=(#14# (#14#)) ((#16# (#16#))))))))))\n     ((#17=(#18=(#19=(#20=(#1# (#1#)) ((#20# (#20#))))\n                 ((#21=(#19# (#19#)) ((#21# (#21#))))))\n            ((#22=(#23=(#18# (#18#)) ((#23# (#23#))))\n              ((#24=(#22# (#22#)) ((#24# (#24#))))))))\n       ((#25=(#26=(#27=(#17# (#17#)) ((#27# (#27#))))\n              ((#28=(#26# (#26#)) ((#28# (#28#))))))\n         ((#29=(#30=(#25# (#25#)) ((#30# (#30#))))\n           ((#31=(#29# (#29#)) ((#31# (#31#))))))))))))\n ((#32=(#33=(#34=(#35=(#36=(#0# (#0#)) ((#36# (#36#))))\n                  ((#37=(#35# (#35#)) ((#37# (#37#))))))\n             ((#38=(#39=(#34# (#34#)) ((#39# (#39#))))\n               ((#40=(#38# (#38#)) ((#40# (#40#))))))))\n        ((#41=(#42=(#43=(#33# (#33#)) ((#43# (#43#))))\n               ((#44=(#42# (#42#)) ((#44# (#44#))))))\n          ((#45=(#46=(#41# (#41#)) ((#46# (#46#))))\n            ((#47=(#45# (#45#)) ((#47# (#47#))))))))))\n   ((#48=(#49=(#50=(#51=(#32# (#32#)) ((#51# (#51#))))\n               ((#52=(#50# (#50#)) ((#52# (#52#))))))\n          ((#53=(#54=(#49# (#49#)) ((#54# (#54#))))\n            ((#55=(#53# (#53#)) ((#55# (#55#))))))))\n     ((#56=(#57=(#58=(#48# (#48#)) ((#58# (#58#))))\n            ((#59=(#57# (#57#)) ((#59# (#59#))))))\n       ((#60=(#61=(#56# (#56#)) ((#61# (#61#))))\n         ((#62=(#60# (#60#)) ((#62# (#62#))))))))))))))\n")

(check-equal?
 (obj->str (shared 8 'foobar) pretty-print #t)
 "(#0=(#1=(#2=(#3=(#4=(#5=(#6=(foobar (foobar)) ((#6# (#6#))))\n                     ((#7=(#5# (#5#)) ((#7# (#7#))))))\n                 ((#8=(#9=(#4# (#4#)) ((#9# (#9#))))\n                   ((#10=(#8# (#8#)) ((#10# (#10#))))))))\n             ((#11=(#12=(#13=(#3# (#3#)) ((#13# (#13#))))\n                    ((#14=(#12# (#12#)) ((#14# (#14#))))))\n               ((#15=(#16=(#11# (#11#)) ((#16# (#16#))))\n                 ((#17=(#15# (#15#)) ((#17# (#17#))))))))))\n         ((#18=(#19=(#20=(#21=(#2# (#2#)) ((#21# (#21#))))\n                     ((#22=(#20# (#20#)) ((#22# (#22#))))))\n                ((#23=(#24=(#19# (#19#)) ((#24# (#24#))))\n                  ((#25=(#23# (#23#)) ((#25# (#25#))))))))\n           ((#26=(#27=(#28=(#18# (#18#)) ((#28# (#28#))))\n                  ((#29=(#27# (#27#)) ((#29# (#29#))))))\n             ((#30=(#31=(#26# (#26#)) ((#31# (#31#))))\n               ((#32=(#30# (#30#)) ((#32# (#32#))))))))))))\n     ((#33=(#34=(#35=(#36=(#37=(#1# (#1#)) ((#37# (#37#))))\n                      ((#38=(#36# (#36#)) ((#38# (#38#))))))\n                 ((#39=(#40=(#35# (#35#)) ((#40# (#40#))))\n                   ((#41=(#39# (#39#)) ((#41# (#41#))))))))\n            ((#42=(#43=(#44=(#34# (#34#)) ((#44# (#44#))))\n                   ((#45=(#43# (#43#)) ((#45# (#45#))))))\n              ((#46=(#47=(#42# (#42#)) ((#47# (#47#))))\n                ((#48=(#46# (#46#)) ((#48# (#48#))))))))))\n       ((#49=(#50=(#51=(#52=(#33# (#33#)) ((#52# (#52#))))\n                   ((#53=(#51# (#51#)) ((#53# (#53#))))))\n              ((#54=(#55=(#50# (#50#)) ((#55# (#55#))))\n                ((#56=(#54# (#54#)) ((#56# (#56#))))))))\n         ((#57=(#58=(#59=(#49# (#49#)) ((#59# (#59#))))\n                ((#60=(#58# (#58#)) ((#60# (#60#))))))\n           ((#61=(#62=(#57# (#57#)) ((#62# (#62#))))\n             ((#63=(#61# (#61#)) ((#63# (#63#))))))))))))))\n ((#64=(#65=(#66=(#67=(#68=(#69=(#0# (#0#)) ((#69# (#69#))))\n                       ((#70=(#68# (#68#)) ((#70# (#70#))))))\n                  ((#71=(#72=(#67# (#67#)) ((#72# (#72#))))\n                    ((#73=(#71# (#71#)) ((#73# (#73#))))))))\n             ((#74=(#75=(#76=(#66# (#66#)) ((#76# (#76#))))\n                    ((#77=(#75# (#75#)) ((#77# (#77#))))))\n               ((#78=(#79=(#74# (#74#)) ((#79# (#79#))))\n                 ((#80=(#78# (#78#)) ((#80# (#80#))))))))))\n        ((#81=(#82=(#83=(#84=(#65# (#65#)) ((#84# (#84#))))\n                    ((#85=(#83# (#83#)) ((#85# (#85#))))))\n               ((#86=(#87=(#82# (#82#)) ((#87# (#87#))))\n                 ((#88=(#86# (#86#)) ((#88# (#88#))))))))\n          ((#89=(#90=(#91=(#81# (#81#)) ((#91# (#91#))))\n                 ((#92=(#90# (#90#)) ((#92# (#92#))))))\n            ((#93=(#94=(#89# (#89#)) ((#94# (#94#))))\n              ((#95=(#93# (#93#)) ((#95# (#95#))))))))))))\n   ((#96=(#97=(#98=(#99=(#100=(#64# (#64#)) ((#100# (#100#))))\n                    ((#101=(#99# (#99#)) ((#101# (#101#))))))\n               ((#102=(#103=(#98# (#98#)) ((#103# (#103#))))\n                 ((#104=(#102# (#102#)) ((#104# (#104#))))))))\n          ((#105=(#106=(#107=(#97# (#97#)) ((#107# (#107#))))\n                  ((#108=(#106# (#106#)) ((#108# (#108#))))))\n            ((#109=(#110=(#105# (#105#)) ((#110# (#110#))))\n              ((#111=(#109# (#109#)) ((#111# (#111#))))))))))\n     ((#112=(#113=(#114=(#115=(#96# (#96#)) ((#115# (#115#))))\n                   ((#116=(#114# (#114#)) ((#116# (#116#))))))\n             ((#117=(#118=(#113# (#113#)) ((#118# (#118#))))\n               ((#119=(#117# (#117#)) ((#119# (#119#))))))))\n       ((#120=(#121=(#122=(#112# (#112#)) ((#122# (#122#))))\n               ((#123=(#121# (#121#)) ((#123# (#123#))))))\n         ((#124=(#125=(#120# (#120#)) ((#125# (#125#))))\n           ((#126=(#124# (#124#)) ((#126# (#126#))))))))))))))))\n")

(check-equal?
 (obj->str (shared 9 'foobar) pretty-print #t)
 "(#0=(#1=(#2=(#3=(#4=(#5=(#6=(#7=(foobar (foobar)) ((#7# (#7#))))\n                         ((#8=(#6# (#6#)) ((#8# (#8#))))))\n                     ((#9=(#10=(#5# (#5#)) ((#10# (#10#))))\n                       ((#11=(#9# (#9#)) ((#11# (#11#))))))))\n                 ((#12=(#13=(#14=(#4# (#4#)) ((#14# (#14#))))\n                        ((#15=(#13# (#13#)) ((#15# (#15#))))))\n                   ((#16=(#17=(#12# (#12#)) ((#17# (#17#))))\n                     ((#18=(#16# (#16#)) ((#18# (#18#))))))))))\n             ((#19=(#20=(#21=(#22=(#3# (#3#)) ((#22# (#22#))))\n                         ((#23=(#21# (#21#)) ((#23# (#23#))))))\n                    ((#24=(#25=(#20# (#20#)) ((#25# (#25#))))\n                      ((#26=(#24# (#24#)) ((#26# (#26#))))))))\n               ((#27=(#28=(#29=(#19# (#19#)) ((#29# (#29#))))\n                      ((#30=(#28# (#28#)) ((#30# (#30#))))))\n                 ((#31=(#32=(#27# (#27#)) ((#32# (#32#))))\n                   ((#33=(#31# (#31#)) ((#33# (#33#))))))))))))\n         ((#34=(#35=(#36=(#37=(#38=(#2# (#2#)) ((#38# (#38#))))\n                          ((#39=(#37# (#37#)) ((#39# (#39#))))))\n                     ((#40=(#41=(#36# (#36#)) ((#41# (#41#))))\n                       ((#42=(#40# (#40#)) ((#42# (#42#))))))))\n                ((#43=(#44=(#45=(#35# (#35#)) ((#45# (#45#))))\n                       ((#46=(#44# (#44#)) ((#46# (#46#))))))\n                  ((#47=(#48=(#43# (#43#)) ((#48# (#48#))))\n                    ((#49=(#47# (#47#)) ((#49# (#49#))))))))))\n           ((#50=(#51=(#52=(#53=(#34# (#34#)) ((#53# (#53#))))\n                       ((#54=(#52# (#52#)) ((#54# (#54#))))))\n                  ((#55=(#56=(#51# (#51#)) ((#56# (#56#))))\n                    ((#57=(#55# (#55#)) ((#57# (#57#))))))))\n             ((#58=(#59=(#60=(#50# (#50#)) ((#60# (#60#))))\n                    ((#61=(#59# (#59#)) ((#61# (#61#))))))\n               ((#62=(#63=(#58# (#58#)) ((#63# (#63#))))\n                 ((#64=(#62# (#62#)) ((#64# (#64#))))))))))))))\n     ((#65=(#66=(#67=(#68=(#69=(#70=(#1# (#1#)) ((#70# (#70#))))\n                           ((#71=(#69# (#69#)) ((#71# (#71#))))))\n                      ((#72=(#73=(#68# (#68#)) ((#73# (#73#))))\n                        ((#74=(#72# (#72#)) ((#74# (#74#))))))))\n                 ((#75=(#76=(#77=(#67# (#67#)) ((#77# (#77#))))\n                        ((#78=(#76# (#76#)) ((#78# (#78#))))))\n                   ((#79=(#80=(#75# (#75#)) ((#80# (#80#))))\n                     ((#81=(#79# (#79#)) ((#81# (#81#))))))))))\n            ((#82=(#83=(#84=(#85=(#66# (#66#)) ((#85# (#85#))))\n                        ((#86=(#84# (#84#)) ((#86# (#86#))))))\n                   ((#87=(#88=(#83# (#83#)) ((#88# (#88#))))\n                     ((#89=(#87# (#87#)) ((#89# (#89#))))))))\n              ((#90=(#91=(#92=(#82# (#82#)) ((#92# (#92#))))\n                     ((#93=(#91# (#91#)) ((#93# (#93#))))))\n                ((#94=(#95=(#90# (#90#)) ((#95# (#95#))))\n                  ((#96=(#94# (#94#)) ((#96# (#96#))))))))))))\n       ((#97=(#98=(#99=(#100=(#101=(#65# (#65#)) ((#101# (#101#))))\n                        ((#102=(#100# (#100#)) ((#102# (#102#))))))\n                   ((#103=(#104=(#99# (#99#)) ((#104# (#104#))))\n                     ((#105=(#103# (#103#)) ((#105# (#105#))))))))\n              ((#106=(#107=(#108=(#98# (#98#)) ((#108# (#108#))))\n                      ((#109=(#107# (#107#)) ((#109# (#109#))))))\n                ((#110=(#111=(#106# (#106#)) ((#111# (#111#))))\n                  ((#112=(#110# (#110#)) ((#112# (#112#))))))))))\n         ((#113=(#114=(#115=(#116=(#97# (#97#)) ((#116# (#116#))))\n                       ((#117=(#115# (#115#)) ((#117# (#117#))))))\n                 ((#118=(#119=(#114# (#114#)) ((#119# (#119#))))\n                   ((#120=(#118# (#118#)) ((#120# (#120#))))))))\n           ((#121=(#122=(#123=(#113# (#113#)) ((#123# (#123#))))\n                   ((#124=(#122# (#122#)) ((#124# (#124#))))))\n             ((#125=(#126=(#121# (#121#)) ((#126# (#126#))))\n               ((#127=(#125# (#125#)) ((#127# (#127#))))))))))))))))\n ((#128=(#129=(#130=(#131=(#132=(#133=(#134=(#0# (#0#)) ((#134# (#134#))))\n                                 ((#135=(#133# (#133#)) ((#135# (#135#))))))\n                           ((#136=(#137=(#132# (#132#)) ((#137# (#137#))))\n                             ((#138=(#136# (#136#)) ((#138# (#138#))))))))\n                     ((#139=(#140=(#141=(#131# (#131#)) ((#141# (#141#))))\n                             ((#142=(#140# (#140#)) ((#142# (#142#))))))\n                       ((#143=(#144=(#139# (#139#)) ((#144# (#144#))))\n                         ((#145=(#143# (#143#)) ((#145# (#145#))))))))))\n               ((#146=(#147=(#148=(#149=(#130# (#130#)) ((#149# (#149#))))\n                             ((#150=(#148# (#148#)) ((#150# (#150#))))))\n                       ((#151=(#152=(#147# (#147#)) ((#152# (#152#))))\n                         ((#153=(#151# (#151#)) ((#153# (#153#))))))))\n                 ((#154=(#155=(#156=(#146# (#146#)) ((#156# (#156#))))\n                         ((#157=(#155# (#155#)) ((#157# (#157#))))))\n                   ((#158=(#159=(#154# (#154#)) ((#159# (#159#))))\n                     ((#160=(#158# (#158#)) ((#160# (#160#))))))))))))\n         ((#161=(#162=(#163=(#164=(#165=(#129# (#129#)) ((#165# (#165#))))\n                             ((#166=(#164# (#164#)) ((#166# (#166#))))))\n                       ((#167=(#168=(#163# (#163#)) ((#168# (#168#))))\n                         ((#169=(#167# (#167#)) ((#169# (#169#))))))))\n                 ((#170=(#171=(#172=(#162# (#162#)) ((#172# (#172#))))\n                         ((#173=(#171# (#171#)) ((#173# (#173#))))))\n                   ((#174=(#175=(#170# (#170#)) ((#175# (#175#))))\n                     ((#176=(#174# (#174#)) ((#176# (#176#))))))))))\n           ((#177=(#178=(#179=(#180=(#161# (#161#)) ((#180# (#180#))))\n                         ((#181=(#179# (#179#)) ((#181# (#181#))))))\n                   ((#182=(#183=(#178# (#178#)) ((#183# (#183#))))\n                     ((#184=(#182# (#182#)) ((#184# (#184#))))))))\n             ((#185=(#186=(#187=(#177# (#177#)) ((#187# (#187#))))\n                     ((#188=(#186# (#186#)) ((#188# (#188#))))))\n               ((#189=(#190=(#185# (#185#)) ((#190# (#190#))))\n                 ((#191=(#189# (#189#)) ((#191# (#191#))))))))))))))\n   ((#192=(#193=(#194=(#195=(#196=(#197=(#128# (#128#)) ((#197# (#197#))))\n                             ((#198=(#196# (#196#)) ((#198# (#198#))))))\n                       ((#199=(#200=(#195# (#195#)) ((#200# (#200#))))\n                         ((#201=(#199# (#199#)) ((#201# (#201#))))))))\n                 ((#202=(#203=(#204=(#194# (#194#)) ((#204# (#204#))))\n                         ((#205=(#203# (#203#)) ((#205# (#205#))))))\n                   ((#206=(#207=(#202# (#202#)) ((#207# (#207#))))\n                     ((#208=(#206# (#206#)) ((#208# (#208#))))))))))\n           ((#209=(#210=(#211=(#212=(#193# (#193#)) ((#212# (#212#))))\n                         ((#213=(#211# (#211#)) ((#213# (#213#))))))\n                   ((#214=(#215=(#210# (#210#)) ((#215# (#215#))))\n                     ((#216=(#214# (#214#)) ((#216# (#216#))))))))\n             ((#217=(#218=(#219=(#209# (#209#)) ((#219# (#219#))))\n                     ((#220=(#218# (#218#)) ((#220# (#220#))))))\n               ((#221=(#222=(#217# (#217#)) ((#222# (#222#))))\n                 ((#223=(#221# (#221#)) ((#223# (#223#))))))))))))\n     ((#224=(#225=(#226=(#227=(#228=(#192# (#192#)) ((#228# (#228#))))\n                         ((#229=(#227# (#227#)) ((#229# (#229#))))))\n                   ((#230=(#231=(#226# (#226#)) ((#231# (#231#))))\n                     ((#232=(#230# (#230#)) ((#232# (#232#))))))))\n             ((#233=(#234=(#235=(#225# (#225#)) ((#235# (#235#))))\n                     ((#236=(#234# (#234#)) ((#236# (#236#))))))\n               ((#237=(#238=(#233# (#233#)) ((#238# (#238#))))\n                 ((#239=(#237# (#237#)) ((#239# (#239#))))))))))\n       ((#240=(#241=(#242=(#243=(#224# (#224#)) ((#243# (#243#))))\n                     ((#244=(#242# (#242#)) ((#244# (#244#))))))\n               ((#245=(#246=(#241# (#241#)) ((#246# (#246#))))\n                 ((#247=(#245# (#245#)) ((#247# (#247#))))))))\n         ((#248=(#249=(#250=(#240# (#240#)) ((#250# (#250#))))\n                 ((#251=(#249# (#249#)) ((#251# (#251#))))))\n           ((#252=(#253=(#248# (#248#)) ((#253# (#253#))))\n             ((#254=(#252# (#252#)) ((#254# (#254#))))))))))))))))))\n")
