
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "runtime.h"


#define stat_f prefix(stat_f)

G95_DINT stat_f(char *file, G95_DINT *sarray, G95_DINT file_len) {
struct stat b;
char *buffer;
int status;

    buffer = string_copy_in(file, file_len);
    status = stat(buffer, &b);
    free_mem(buffer);

    sarray[0] = b.st_dev;
    sarray[1] = b.st_ino;
    sarray[2] = b.st_mode;
    sarray[3] = b.st_nlink;
    sarray[4] = b.st_uid;
    sarray[5] = b.st_gid;
    sarray[6] = b.st_rdev;
    sarray[7] = b.st_size;
    sarray[8] = b.st_atime;
    sarray[9] = b.st_mtime;
    sarray[10] = b.st_ctime;
    sarray[11] = b.st_blksize;
    sarray[12] = b.st_blocks;

    return status;
}


#define stat_s prefix(stat_s)

void stat_s(char *file, G95_DINT *sarray, G95_DINT *status, G95_DINT file_len){
struct stat b;
char *buffer;

    buffer = string_copy_in(file, file_len);
    *status = stat(buffer, &b);
    free_mem(buffer);

    sarray[0] = b.st_dev;
    sarray[1] = b.st_ino;
    sarray[2] = b.st_mode;
    sarray[3] = b.st_nlink;
    sarray[4] = b.st_uid;
    sarray[5] = b.st_gid;
    sarray[6] = b.st_rdev;
    sarray[7] = b.st_size;
    sarray[8] = b.st_atime;
    sarray[9] = b.st_mtime;
    sarray[10] = b.st_ctime;
    sarray[11] = b.st_blksize;
    sarray[12] = b.st_blocks;
}


#define lstat_f prefix(lstat_f)

G95_DINT lstat_f(char *file, G95_DINT *sarray, G95_DINT file_len) {
struct stat b;
char *buffer;
int status;

    buffer = string_copy_in(file, file_len);
    status = lstat(buffer, &b);
    free_mem(buffer);

    sarray[0] = b.st_dev;
    sarray[1] = b.st_ino;
    sarray[2] = b.st_mode;
    sarray[3] = b.st_nlink;
    sarray[4] = b.st_uid;
    sarray[5] = b.st_gid;
    sarray[6] = b.st_rdev;
    sarray[7] = b.st_size;
    sarray[8] = b.st_atime;
    sarray[9] = b.st_mtime;
    sarray[10] = b.st_ctime;
    sarray[11] = b.st_blksize;
    sarray[12] = b.st_blocks;

    return status;
}


#define lstat_s prefix(lstat_s)

void lstat_s(char *file, G95_DINT *sarray, G95_DINT *status,
	     G95_DINT file_len) {
struct stat b;
char *buffer;

    buffer = string_copy_in(file, file_len);
    *status = lstat(buffer, &b);
    free_mem(buffer);

    sarray[0] = b.st_dev;
    sarray[1] = b.st_ino;
    sarray[2] = b.st_mode;
    sarray[3] = b.st_nlink;
    sarray[4] = b.st_uid;
    sarray[5] = b.st_gid;
    sarray[6] = b.st_rdev;
    sarray[7] = b.st_size;
    sarray[8] = b.st_atime;
    sarray[9] = b.st_mtime;
    sarray[10] = b.st_ctime;
    sarray[11] = b.st_blksize;
    sarray[12] = b.st_blocks;
}


#define fstat_f prefix(fstat_f)

G95_DINT fstat_f(G95_DINT *unit, G95_DINT *sarray) {
struct stat b;
int status;
iounit_t *u;

    u = find_unit(unit, sizeof(G95_DINT));
    if (u == NULL)
	status = -1;
    else {
	status = fstat(u->s->fd, &b);

	sarray[0] = b.st_dev;
	sarray[1] = b.st_ino;
	sarray[2] = b.st_mode;
	sarray[3] = b.st_nlink;
	sarray[4] = b.st_uid;
	sarray[5] = b.st_gid;
	sarray[6] = b.st_rdev;
	sarray[7] = b.st_size;
	sarray[8] = b.st_atime;
	sarray[9] = b.st_mtime;
	sarray[10] = b.st_ctime;
	sarray[11] = b.st_blksize;
	sarray[12] = b.st_blocks;
    }

    return status;
}


#define fstat_s prefix(fstat_s)

void fstat_s(G95_DINT *unit, G95_DINT *sarray, G95_DINT *status) {
struct stat b;
iounit_t *u;

    u = find_unit(unit, sizeof(G95_DINT));
    if (u == NULL)
	*status = -1;
    else {
	*status = fstat(u->s->fd, &b);

	sarray[0] = b.st_dev;
	sarray[1] = b.st_ino;
	sarray[2] = b.st_mode;
	sarray[3] = b.st_nlink;
	sarray[4] = b.st_uid;
	sarray[5] = b.st_gid;
	sarray[6] = b.st_rdev;
	sarray[7] = b.st_size;
	sarray[8] = b.st_atime;
	sarray[9] = b.st_mtime;
	sarray[10] = b.st_ctime;
	sarray[11] = b.st_blksize;
	sarray[12] = b.st_blocks;
    }
}
