
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the cshift() intrinsic. */

#include <string.h>
#include "runtime.h"


#define cshift1 prefix(cshift1)

g95_array_descriptor *cshift1(g95_array_descriptor *array, G95_DINT *shift_p,
			      G95_DINT *dim_p) {
G95_AINT extent, d_extent, element_size, shift, dim, s, x[G95_MAX_DIMENSIONS];
int i, n, rank, zero_size;
g95_array_descriptor *r;
char *p1, *p2, *q1, *q2;

    dim = (dim_p == NULL) ? 0 : *dim_p - 1;   /* Zero based */
    shift = *shift_p;

    rank = array->rank;
    element_size = array->element_size;

    section_info[0] = array->rank;
    section_info[1] = array->element_size;

    n = 2;
    zero_size = 0;
    d_extent = 0;

    for(i=0; i<rank; i++) {
	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	if (i == dim)
	    d_extent = extent;

	section_info[n++] = 1;
	section_info[n++] = extent;

	x[i] = 1;
    }

    r = array_from_section(NULL);
    if (zero_size)
	goto done;

    for(;;) {
	p1 = r->offset;
	q1 = array->offset;

	for(i=0; i<rank; i++)
	    if (i != dim) {
		p1 += r->info[i].mult * x[i];
		q1 += array->info[i].mult*(array->info[i].lbound + x[i] - 1);
	    }

	/* Circular shift along DIM */

	for(i=0; i<d_extent; i++) {
	    s = (i - shift) % d_extent;
	    if (s < 0)
		s += d_extent;

	    p2 = p1 + r->info[dim].mult*(s + 1);
	    q2 = q1 + array->info[dim].mult*(i + array->info[dim].lbound);

	    memcpy(p2, q2, element_size);
	}

	if (bump_element_dim(r, x, dim))
	    break;
    }

done:
    return r;
}


#define cshift2 prefix(cshift2)

g95_array_descriptor *cshift2(g95_array_descriptor *array,
			      g95_array_descriptor *shift, G95_DINT *dim_p) {
G95_AINT extent, dim, s, shft, d_extent, element_size, x[G95_MAX_DIMENSIONS];
char *p1, *p2, *q1, *q2, *m;
int i, n, rank, zero_size;
g95_array_descriptor *r;

    dim = (dim_p == NULL) ? 0 : *dim_p - 1;   /* Zero based */

    rank = array->rank;
    element_size = array->element_size;

    section_info[0] = array->rank;
    section_info[1] = array->element_size;

    n = 2;
    zero_size = 0;
    d_extent = shft = 0;

    for(i=0; i<rank; i++) {
	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	if (i == dim)
	    d_extent = extent;

	section_info[n++] = 1;
	section_info[n++] = extent;

	x[i] = 1;
    }

    r = array_from_section(NULL);
    if (zero_size)
	goto done;

    for(;;) {
	p1 = r->offset;
	q1 = array->offset;
	m = shift->offset;

	for(i=0; i<rank; i++) {
	    if (i != dim) {
		p1 += r->info[i].mult * x[i];
		q1 += array->info[i].mult*(array->info[i].lbound + x[i] - 1);
	    }

	    if (i < dim)
		m += shift->info[i].mult*(shift->info[i].lbound + x[i] - 1);

	    if (i > dim)
		m += shift->info[i-1].mult*(shift->info[i-1].lbound + x[i]-1);
	}

	shft = extract_dint(m, shift->element_size);

	/* Circular shift along DIM */

	for(i=0; i<d_extent; i++) {
	    s = (i - shft) % d_extent;
	    if (s < 0)
		s += d_extent;

	    p2 = p1 + r->info[dim].mult*(s + 1);
	    q2 = q1 + array->info[dim].mult*(i + array->info[dim].lbound);

	    memcpy(p2, q2, element_size);
	}

	if (bump_element_dim(r, x, dim))
	    break;
    }

done:
    return r;
}

