
#include "comb/perm-st-pref.h"
//demo-include "comb/endo-enup.h"


#include "comb/comb-print.h"
#include "aux0/swap.h"

#include "fxtio.h"
#include "nextarg.h"
#include "fxttypes.h"


//% Single track ordering for permutations, swaps in prefix, CAT algorithm.

// Cf. seq/A368948-demo.cc

//#define TIMING  // uncomment to disable printing


int
main(int argc, char **argv)
{
    ulong n = 4;
    NXARG(n, "Number of elements to permute");

    perm_st_pref P(n);
    P.first();

    ulong ct = 0;

#if defined TIMING

    do  { ++ct; }  while ( P.next() );

#else  // TIMING

    const bool dfz= true;  // whether to print dots for zeros
    do
    {
        cout << setw(4) << ct << ":";
        P.print("    ", dfz);
        P.print_inv("    ", dfz);
        print_mixedradix("    ", P.M, n-(n!=0), dfz);

        if ( ct != 0 )
        {
            // print swaps:
            // (elements in permutation, or positions in inverse permutation)
            ulong j = 0;
            while ( P.M[j] == 0 )  { ++j; }
            cout << "    " << j << ": ";
            for (ulong e1=j&1, e2=e1+1;  e1<=j;  e1+=2, e2+=2)
            {
                cout << "(" << e1 << "," << e2 << ")";
                if ( e1 < j )  cout << " ";
            }
        }

        cout << endl;
        ++ct;
    }
    while ( P.next() );

#endif  // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time  ./bin 12
arg 1: 12 == n  [Number of elements to permute]  default=4
arg 2: 1 == iq  [Whether first permutation is the identical permutation]  default=1
 ct=479001600
1.16user 0.00system 0:01.16elapsed 100%CPU
 ==> 12!/1.16 == 412,932,413 per second

*/

/*
Timing: (AMD Phenom II X4 945 3000MHz)

// using for-loop; in next():
time  ./bin 12
arg 1: 12 == n  [Number of elements to permute]  default=4
arg 2: 1 == iq  [Whether first permutation is the identical permutation]  default=1
 ct=479001600
./bin 12  2.36s user 0.00s system 99% cpu 2.358 total
 ==> 12!/2.36 == 202,966,779 per second

// using do ... while in next():
time  ./bin 12
arg 1: 12 == n  [Number of elements to permute]  default=4
arg 2: 1 == iq  [Whether first permutation is the identical permutation]  default=1
 ct=479001600
./bin 12  2.30s user 0.00s system 99% cpu 2.305 total
 ==> 12!/2.30 == 208,261,565 per second

*/



/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/perm-st-pref-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/perm-st-pref-demo.cc DEMOFLAGS=-DTIMING"
/// End:

