
#include "comb/mset-kperm-lex.h"
// demo-include "comb/mset-perm-lex.h"

#include "comb/fact2perm.h"
#include "comb/comb-print.h"

#include "fxttypes.h"
#include "fxtio.h"
#include "jjassert.h"
#include "nextarg.h"

#include <cstdlib>  // strtoul()


//% All k-permutations of a multiset in lexicographic order.


//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong plen = 4;   // length of prefix
    NXARG( plen, "length of prefix")
    ulong k;   // number of sorts of elements
    ulong *r;  // element i is repeated r[i] times

    cout << "args: multiplicities of elements" << endl;
    if ( argc<=2 )
    {
        ulong t[]={2, 2, 2, 0};  // proper multisets  ct=54
//        ulong t[]={3, 2, 1, 0};  // proper multisets  ct=30
//        ulong t[]={1, 1, 1, 1, 0};  // permutations  ct = 24
//        ulong t[]={6, 2, 0};  // combinations  ct=28
        k=0;  while ( t[k] )  { ++k; }
        r = new ulong[k];
        for (ulong j=0; j<k; ++j)  r[j] = t[j];
    }
    else
    {
        k = (ulong)argc - 2;
        r = new ulong[k];
        for (ulong j=0; j<k; ++j)
        {
            ulong t = strtoul(argv[j+2], nullptr, 10);
            r[j] = t;
        }
    }

    mset_kperm_lex P(r, k, plen);
    const ulong n = P.num_parts();

    cout << "multiplicities: ( ";
    for (ulong i=0; i<k; ++i)
        cout << P.multiplicities()[i] << (i<k-1?", ":" ");
    cout << ")";
//    cout << "  k=" << P.k_ << "  n=" << P.n_;
    cout << "  k=" << P.num_sorts() << "  n=" << P.num_parts();
    cout << endl;

    jjassert( plen <= n );

    ulong ct = 0;

#if defined TIMING
    do  { ++ct; }  while ( n != P.next() );

#else  // TIMING

//    ulong F[n];
    const bool dfz = true;  // whether to print dots for zeros
    ulong j = plen;
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";
        P.print("  ", dfz);
        P.print_suffix("  ", dfz);
        cout << setw(4) << j;
//        perm2ffact( P.data(), n, F);
//        print_vec( "    ", F, n-1, true );

        cout << endl;
    }
    while ( n != (j=P.next()) );

#endif  // TIMING

    delete [] r;



    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0
time  ./bin 12 1 1 1 1 1 1 1 1 1 1 1 1  ## all permutations of 12
arg 1: 12 == plen  [length of prefix]  default=4
args: multiplicities of elements
multiplicities: ( 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 )  k=12  n=12
 ct=479001600
1.75user 0.00system 0:01.75elapsed 100%CPU
 ==> 479001600 / 1.75  == 273,715,200 per second

 time  ./bin 10 1 1 1 1 1 1 1 1 1 1 1 1  ## 10-prefixes of permutations of 12
 args: multiplicities of elements
multiplicities: ( 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 )  k=12  n=12
 ct=239500800
1.22user 0.00system 0:01.22elapsed 100%CPU
 ==> 239500800 / 1.22  == 196,312,131 per second

time ./bin 7 2 2 2 2 2 2 2 2 2 2 2 2 2  ## 7-prefixes of permutations of [2^13]
arg 1: 7 == plen  [length of prefix]  default=4
args: multiplicities of elements
multiplicities: ( 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 )  k=13  n=26
 ct=52612560
1.61user 0.00system 0:01.61elapsed 100%CPU
 ==> 52612560 / 1.61 == 32,678,608 per second

time ./bin 8 3 3 3 3 3 3 3 3 3 3 3  ## 8-prefixes of permutations of [3^11]
arg 1: 8 == plen  [length of prefix]  default=4
args: multiplicities of elements
multiplicities: ( 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 )  k=11  n=33
 ct=206015040
8.16user 0.00system 0:08.16elapsed 100%CPU
 ==> 206015040 / 8.16 == 25,246,941 per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/mset-kperm-lex-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/mset-kperm-lex-demo.cc DEMOFLAGS=-DTIMING"
/// End:
