
#include "comb/combination-enup.h"

#include "nextarg.h"
#include "fxtio.h"
#include "fxttypes.h"


//% Combinations in a strong minimal-change order (enup steps).
//% The set (as opposed to delta set) is generated.
//% Generation via enup/endo counting.

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 8;
    NXARG(n, "Combinations (n choose k)");
    ulong k = 3;
    NXARG(k, "k elements at a time");

    combination_enup C(n, k);

    ulong j = 0;
    ulong ct = 0;
    do
    {
        ++ct;
#if !defined TIMING
        cout << setw(4) << ct << ":";
        C.print_set("    ");
        C.print_deltaset("    ");

//        cout << "    ";  // composition
//        for (ulong i=1; i<=k; ++i)  cout << " " << (x[i]-x[i-1]);

        cout << endl;
#endif  // TIMING

        j = C.next();
    }
    while ( j<k );

    cout << " ct = " << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

 time ./bin 32 20
arg 1: 32 == n  [Combinations (n choose k)]  default=8
arg 2: 20 == k  [k elements at a time]  default=3
 ct = 225792840
1.31user 0.00system 0:01.31elapsed 100%CPU
==> 225792840/1.31 == 172,360,946 per second

 time ./bin 32 12
arg 1: 32 == n  [Combinations (n choose k)]  default=8
arg 2: 12 == k  [k elements at a time]  default=3
 ct = 225792840
1.04user 0.00system 0:01.04elapsed 100%CPU
==> 225792840/1.04 == 217,108,500 per second

*/

/*
Timing: (AMD Phenom II X4 945 3000MHz)

 time ./bin 32 20
./bin 32 20  2.58s user 0.00s system 99% cpu 2.584 total
 ==> 225792840/2.58 == 87,516,604 per second

 time ./bin 32 12
./bin 32 12  2.03s user 0.00s system 99% cpu 2.039 total
 ==> 225792840/2.03 == 111,228,000 per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/combination-enup-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/combination-enup-demo.cc DEMOFLAGS=-DTIMING"
/// End:
