
#include "comb/perm-lex.h"
#include "perm/permq.h"  // perm_count_left/right-displacements()


#include "fxttypes.h"
#include "fxtio.h"
#include "nextarg.h"


//% Generate OEIS sequences A369376 and A369377:
//% Number of right/left displacements in permutations in lex order.

//#define TIMING  // uncomment to just print sequence


int
main(int argc, char **argv)
{
    ulong n = 4;
    NXARG(n, "Permutations of n elements.");
    bool rq = 1;
    NXARG(rq, "0 ==> left displacements, 1 ==> right displacements.");

    perm_lex P(n);
    const ulong *x = P.data();
    ulong ct = 0;

#if defined TIMING
    bool bfq = 0;
    NXARG(bfq, "0 ==> list, 1 ==> b-file.");
    do
    {
        if ( rq )
        {
            if ( bfq )
                cout << ct << " " << perm_count_right_displacements(x, n) << "\n";
            else
                cout << perm_count_right_displacements(x, n) << ", ";
        }
        else
        {
            if ( bfq )
                cout << ct << " " << perm_count_left_displacements(x, n) << "\n";
            else
                cout << perm_count_left_displacements(x, n) << ", ";
        }
        ++ct;
    }
    while ( P.next() );
    cout << endl;

#else  // TIMING


    bool dfz= true;  // whether to print dots for zeros

    cout << "         permutation         inv. perm.";
    cout << endl;

    do
    {
        cout << setw(4) << ct << ":";
        P.print("    ", dfz);
//        cout << setw(3) << P.pos();
        P.print_inv("    ", dfz);
//        print_vec("      ", P.d_, n, true);  // factorial numbers

        if ( rq )  cout << setw(4) << perm_count_right_displacements(x, n);
        else       cout << setw(4) << perm_count_left_displacements(x, n);
        cout << endl;


        ++ct;
    }
    while ( P.next() );

#endif  // TIMING

    cout << "ct=" << ct << endl;

    return 0;
}
// -------------------------


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/seq"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/seq/A369376-demo.cc"
/// make-target2: "1demo DSRC=demo/seq/A369376-demo.cc DEMOFLAGS=-DTIMING"
/// End:
