
#include "comb/weak-ascent-rgs.h"

#include "comb/comb-print.h"

#include "fxtio.h"
#include "fxttypes.h"
#include "jjassert.h"

#include "nextarg.h"


//% Weak ascent sequences (restricted growth strings, RGS), lexicographic order.
//% A weak ascent sequence is a sequence [d(1), d(2), ..., d(n)] where d(1)=0, d(k)>=0,
//%   and d(k) <= 1 + asc([d(1), d(2), ..., d(k-1)]) and asc(.) counts the
//%   number of weak ascents d(j) >= d(j-1) of its argument.
//% See OEIS sequences A336070, A369321, A369322.

// Cf. comb/ascent-rgs-demo.cc for ascent sequences

//#define TIMING  // uncomment to disable printing


int
main(int argc, char **argv)
{
    ulong n = 4;
    NXARG(n, "Length of strings");
    weak_ascent_rgs A(n);

    ulong ct = 0;

#if defined TIMING
#if defined WEAK_ASCENT_RGS_FIXARRAYS
    cout << "WEAK_ASCENT_RGS_FIXARRAYS defined." << endl;
#endif

    A.first();
    do  { ++ct; }  while ( A.next() );
#else

//    ulong * S = new ulong[n]; // stats: A369321
//    for (ulong k=0; k<n; ++k)  { S[k] = 0; }

    ulong j = n;
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";
        A.print("  ", true ); // RGS
        cout << setw(4) << j;
//        cout << "   a=" << A.num_weak_ascents();
//        S[ A.num_weak_ascents() ] += 1;
//        print_vec("    ", A.M, n, true );  // ascent stats
        cout << endl;

        jjassert( A.OK() );
    }
    while ( (j=A.next()) );

#endif  // TIMING

    cout << " ct=" << ct;  // OEIS sequence A022493
    cout << endl;

//    cout << " stats: ";  // OEIS sequence A369321
//    for (ulong k=0; k<n; ++k)  { cout << S[k] << ", "; }
//    delete [] S;
//    cout << endl;

    return 0;
}
// -------------------------

/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 12.2.0

time ./bin 13
arg 1: 13 == n  [Length of strings]  default=4
WEAK_ASCENT_RGS_FIXARRAYS defined.
 ct=1199306902
2.38user 0.00system 0:02.38elapsed 99%CPU
 ==> 1199306902/2.38 == 503,910,463 per second

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/weak-ascent-rgs-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/weak-ascent-rgs-demo.cc DEMOFLAGS=-DTIMING"
/// End:

