
#include "comb/msetpart.h"

//#include "comb/comb-print.h"

#include "fxttypes.h"
#include "jjassert.h"
#include "nextarg.h"

#include <iostream>
#include <iomanip>
#include <vector>

//% Multiset partitions.
//% Knuth's algorithm M, section 7.1.2.5, p.429-430, Vol.4A, TAOCP.
//% OEIS sequences:
//% A020555: content 2, 2, 2, ..., 2 (n times)
//% A322487: content 3, 3, 3, ..., 3 (n times)
//% A358781: content 4, 4, 4, ..., 4 (n times)
//% A322488: content n, n, n, ..., n (n times)
//% A317829: content 1, 2, 3, ..., n
//% A000110: content 1, 1, 1, ..., 1 (n times): set partitions
//% A000041: content n:  integer partitions

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    std::vector<ulong> M;
    if ( argc > 1 )
    {
        RESTARGS("Content");
        for (int k=1;  k<argc; ++k)
        {
            const ulong v = strtoul(argv[k], nullptr, 10);
            M.push_back( v );
        }
    }
    else
    {
        M.push_back( 2 );
        M.push_back( 2 );
        M.push_back( 2 );
    }

    ulong n = 0;
    for ( const auto & e : M )  { n += e; }
    cout << "n = " << n << "\n";
    jjassert( n > 0 );
//    jjassert( M[0] > 0 );

    msetpart P( M );
    ulong ct = 0;
    do
    {
        ++ct;
#ifdef TIMING
#else
        std::cout << std::setw(4) << ct << ":  ";
        P.print();
        std::cout << '\n';
#endif
    }
    while ( P.next() );

    std::cout << " ct = " << ct << '\n';

    return 0;
}
// -------------------------

/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)
GCC 12.2.0

/// using three arrays C[], U[], V[]

// multiset partitions:
time ./bin 2 2 2 2 2 2 2 2
args 1,2,... : [Content]
n = 16
 ct = 132315780
3.00user 0.00system 0:03.00elapsed 100%CPU
 ==> 132315780/3.00 == 44,105,260 per second

// set partitions:
time ./bin $(for n in $(seq 14); do echo '1 '; done)
args 1,2,... : [Content]
n = 14
 ct = 190899322
4.31user 0.00system 0:04.31elapsed 100%CPU
 ==> 190899322/4.31 == 44,292,186 per second

// integer partitions:
time ./bin 85
args 1,2,... : [Content]
n = 85
 ct = 30167357
2.91user 0.00system 0:02.91elapsed 99%CPU
 ==> 190569292/2.91 == 65,487,729 per second


/// using arrays of structs { C, U, V }:
todo

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/msetpart-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/msetpart-demo.cc DEMOFLAGS=-DTIMING"
/// End:
