
#include "comb/mset-perm-pref.h"

#include "comb/comb-print.h"
#include "fxtio.h"
#include "jjassert.h"
#include "fxttypes.h"

#include <cstdlib>  // strtoul()



//% Multiset permutations via prefix shifts ("cool-lex" order).
//% See
//%  Aaron Williams: Loopless Generation of Multiset Permutations using
//%  a Constant Number of Variables by Prefix Shifts,
//%  ACM-SIAM Symposium on Discrete Algorithms (SODA09), (2009).


//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong k;   // number of sorts of elements
    ulong *r;  // element i is repeated r[i] times

    cout << "args: multiplicities of elements" << endl;
    if ( argc<=1 )
    {
        ulong t[]={2, 2, 1, 0};  // proper multisets  ct=30
//        ulong t[]={1, 1, 1, 1, 0};  // permutations  ct = 24
//        ulong t[]={6, 2, 0};  // combinations  ct=28
        k=0;  while ( t[k] )  { ++k; }
        r = new ulong[k];
        for (ulong j=0; j<k; ++j)  r[j] = t[j];
    }
    else
    {
        k = (ulong)argc - 1;
        r = new ulong[k];
        for (ulong j=0; j<k; ++j)
        {
            ulong t = strtoul(argv[j+1], nullptr, 10);
            r[j] = t;
        }
    }

    mset_perm_pref P(r, k);

    cout << "multiplicities: ( ";
    for (ulong i=0; i<k; ++i)  cout << P.r_[i] << (i<k-1?", ":" ");
    cout << ")";
    cout << "  k=" << P.k_ << "  n=" << P.n_;
    cout << endl;

#if !defined TIMING
    const ulong n = P.n_;
    jjassert( n > 0 );
#else
#if defined MSET_PERM_PREF_OPT
    cout << "MSET_PERM_PREF_OPT is defined\n";
#endif
#endif

    ulong ct = 0;
    ulong i = P.n_;
    do
    {
        ++ct;
#if !defined TIMING
        const ulong *x = P.data();
        const bool dfz = true;  // whether to print dots for zeros

        cout << setw(4) << ct << ":";
        print_perm("  ", x, n, dfz);
        cout << "  " << i;

        cout << endl;
#endif
//        break;
        i = P.next();
    }
    while ( i );


    cout << " ct=" << ct << endl;

    delete [] r;

    return 0;
}
// -------------------------

/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

 ============ MSET_PERM_PREF_OPT #defined, O(1) update of prefix length:

time ./bin 2 2 2 3 3 3
args: multiplicities of elements
multiplicities: ( 2, 2, 2, 3, 3, 3 )  k=6  n=15
MSET_PERM_PREF_OPT is defined
 ct=756756000
5.01user 0.00system 0:05.01elapsed 100%CPU
 ==> 756756000/5.01 == 151,049,101 per second

time ./bin 3 3 3 2 2 2 ## reordered
args: multiplicities of elements
multiplicities: ( 3, 3, 3, 2, 2, 2 )  k=6  n=15
MSET_PERM_PREF_OPT is defined
 ct=756756000
5.03user 0.00system 0:05.03elapsed 100%CPU
 ==> 756756000/5.03 == 150,448,508 per second

time  ./bin 1 1 1 1 1 1 1 1 1 1 1 1  ## permutations of 12
args: multiplicities of elements
multiplicities: ( 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 )  k=12  n=12
MSET_PERM_PREF_OPT is defined
 ct=479001600
3.15user 0.00system 0:03.15elapsed 100%CPU
 ==> 479001600/3.15 == 152,064,000 per second

time  ./bin 15 15  ## combinations (30 choose 15)
args: multiplicities of elements
multiplicities: ( 15, 15 )  k=2  n=30
MSET_PERM_PREF_OPT is defined
 ct=155117520
1.03user 0.00system 0:01.03elapsed 99%CPU
 ==> 155117520/1.03 == 150,599,533 per second

 ============ MSET_PERM_PREF_OPT not #defined:

time ./bin 2 2 2 3 3 3
args: multiplicities of elements
multiplicities: ( 2, 2, 2, 3, 3, 3 )  k=6  n=15
 ct=756756000
4.07user 0.00system 0:04.07elapsed 100%CPU
 ==> 756756000/4.07 == 185,935,135 per second

time ./bin 3 3 3 2 2 2 ## reordered
args: multiplicities of elements
multiplicities: ( 3, 3, 3, 2, 2, 2 )  k=6  n=15
 ct=756756000
4.03user 0.00system 0:04.06elapsed 99%CPU
 ==> 756756000/4.03 == 189,189,000 per second

time  ./bin 1 1 1 1 1 1 1 1 1 1 1 1  ## permutations of 12
args: multiplicities of elements
multiplicities: ( 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 )  k=12  n=12
 ct=479001600
2.40user 0.00system 0:02.40elapsed 99%CPU
 ==> 479001600/2.40 == 199,584,000 per second

time  ./bin 15 15  ## combinations (30 choose 15)
args: multiplicities of elements
multiplicities: ( 15, 15 )  k=2  n=30
 ct=155117520
0.86user 0.00system 0:00.86elapsed 99%CPU
 ==> 155117520/0.86 == 180,369,209 per second
*/

/*
BENCHARGS= 2 2 2 3 3 3
BENCHARGS= 3 3 3 2 2 2 ## reordered
BENCHARGS= 1 1 1 1 1 1 1 1 1 1 1 1  ## permutations of 12
BENCHARGS= 15 15  ## combinations (30 choose 15)

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/mset-perm-pref-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/mset-perm-pref-demo.cc DEMOFLAGS=-DTIMING"
/// End:
